/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi;

import com.prove.proveapi.SecuritySource;
import com.prove.proveapi.hooks.ClientCredentialsHook;
import com.prove.proveapi.hooks.SDKHooks;
import com.prove.proveapi.utils.HTTPClient;
import com.prove.proveapi.utils.Hook;
import com.prove.proveapi.utils.Hooks;
import com.prove.proveapi.utils.RetryConfig;
import java.util.Optional;

class SDKConfiguration {
    public SecuritySource securitySource;
    public HTTPClient defaultClient;
    public String serverUrl;
    public String server;
    private static final String LANGUAGE = "java";
    public static final String OPENAPI_DOC_VERSION = "1.0.0";
    public static final String SDK_VERSION = "0.11.0";
    public static final String GEN_VERSION = "2.472.1";
    private static final String BASE_PACKAGE = "com.prove.proveapi";
    public static final String USER_AGENT = String.format("speakeasy-sdk/%s %s %s %s %s", "java", "0.11.0", "2.472.1", "1.0.0", "com.prove.proveapi");
    private Hooks _hooks = SDKConfiguration.createHooks();
    public Optional<RetryConfig> retryConfig = Optional.empty();

    SDKConfiguration() {
    }

    public Optional<SecuritySource> securitySource() {
        return Optional.ofNullable(this.securitySource);
    }

    private static Hooks createHooks() {
        Hooks hooks = new Hooks();
        ClientCredentialsHook h = new ClientCredentialsHook();
        hooks.registerSdkInit(h);
        hooks.registerBeforeRequest(h);
        hooks.registerAfterError(h);
        return hooks;
    }

    public Hooks hooks() {
        return this._hooks;
    }

    public void setHooks(Hooks hooks) {
        this._hooks = hooks;
    }

    public void initialize() {
        SDKHooks.initialize(this._hooks);
        Hook.SdkInitData data = this._hooks.sdkInit(new Hook.SdkInitData(this.serverUrl, this.defaultClient));
        this.serverUrl = data.baseUrl();
        this.defaultClient = data.client();
    }
}

