/*
 * Decompiled with CFR 0.152.
 */
package lists.DynamicArrayNumbers.DynamicArrayNumbersFunctions;

import arrays.arrays.arrays;
import lists.DynamicArrayNumbers.Structures.DynamicArrayNumbers;
import lists.LinkedListNumbers.LinkedListNumbersFunctions.LinkedListNumbersFunctions;
import lists.LinkedListNumbers.Structures.LinkedListNodeNumbers;
import lists.LinkedListNumbers.Structures.LinkedListNumbers;

public class DynamicArrayNumbersFunctions {
    public static DynamicArrayNumbers CreateDynamicArrayNumbers() {
        DynamicArrayNumbers da = new DynamicArrayNumbers();
        da.array = new double[10];
        da.length = 0.0;
        return da;
    }

    public static DynamicArrayNumbers CreateDynamicArrayNumbersWithInitialCapacity(double capacity) {
        DynamicArrayNumbers da = new DynamicArrayNumbers();
        da.array = new double[(int)capacity];
        da.length = 0.0;
        return da;
    }

    public static void DynamicArrayAddNumber(DynamicArrayNumbers da, double value) {
        if (da.length == (double)da.array.length) {
            DynamicArrayNumbersFunctions.DynamicArrayNumbersIncreaseSize(da);
        }
        da.array[(int)da.length] = value;
        da.length += 1.0;
    }

    public static void DynamicArrayNumbersIncreaseSize(DynamicArrayNumbers da) {
        double newLength = Math.round((double)da.array.length * 3.0 / 2.0);
        double[] newArray = new double[(int)newLength];
        for (double i = 0.0; i < (double)da.array.length; i += 1.0) {
            newArray[(int)i] = da.array[(int)i];
        }
        DynamicArrayNumbersFunctions.delete(da.array);
        da.array = newArray;
    }

    public static boolean DynamicArrayNumbersDecreaseSizeNecessary(DynamicArrayNumbers da) {
        boolean needsDecrease = false;
        if (da.length > 10.0) {
            needsDecrease = da.length <= (double)Math.round((double)da.array.length * 2.0 / 3.0);
        }
        return needsDecrease;
    }

    public static void DynamicArrayNumbersDecreaseSize(DynamicArrayNumbers da) {
        double newLength = Math.round((double)da.array.length * 2.0 / 3.0);
        double[] newArray = new double[(int)newLength];
        for (double i = 0.0; i < (double)da.array.length; i += 1.0) {
            newArray[(int)i] = da.array[(int)i];
        }
        DynamicArrayNumbersFunctions.delete(da.array);
        da.array = newArray;
    }

    public static double DynamicArrayNumbersIndex(DynamicArrayNumbers da, double index) {
        return da.array[(int)index];
    }

    public static double DynamicArrayNumbersLength(DynamicArrayNumbers da) {
        return da.length;
    }

    public static void DynamicArrayInsertNumber(DynamicArrayNumbers da, double index, double value) {
        if (da.length == (double)da.array.length) {
            DynamicArrayNumbersFunctions.DynamicArrayNumbersIncreaseSize(da);
        }
        for (double i = da.length; i > index; i -= 1.0) {
            da.array[(int)i] = da.array[(int)(i - 1.0)];
        }
        da.array[(int)index] = value;
        da.length += 1.0;
    }

    public static void DynamicArraySet(DynamicArrayNumbers da, double index, double value) {
        da.array[(int)index] = value;
    }

    public static void DynamicArrayRemoveNumber(DynamicArrayNumbers da, double index) {
        for (double i = index; i < da.length - 1.0; i += 1.0) {
            da.array[(int)i] = da.array[(int)(i + 1.0)];
        }
        da.length -= 1.0;
        if (DynamicArrayNumbersFunctions.DynamicArrayNumbersDecreaseSizeNecessary(da)) {
            DynamicArrayNumbersFunctions.DynamicArrayNumbersDecreaseSize(da);
        }
    }

    public static void FreeDynamicArrayNumbers(DynamicArrayNumbers da) {
        DynamicArrayNumbersFunctions.delete(da.array);
        DynamicArrayNumbersFunctions.delete(da);
    }

    public static double[] DynamicArrayNumbersToArray(DynamicArrayNumbers da) {
        double[] array = new double[(int)da.length];
        for (double i = 0.0; i < da.length; i += 1.0) {
            array[(int)i] = da.array[(int)i];
        }
        return array;
    }

    public static DynamicArrayNumbers ArrayToDynamicArrayNumbersWithOptimalSize(double[] array) {
        double c = array.length;
        double n = (Math.log(c) - 1.0) / Math.log(1.5);
        double newCapacity = Math.floor(n) + 1.0;
        DynamicArrayNumbers da = DynamicArrayNumbersFunctions.CreateDynamicArrayNumbersWithInitialCapacity(newCapacity);
        for (double i = 0.0; i < (double)array.length; i += 1.0) {
            da.array[(int)i] = array[(int)i];
        }
        return da;
    }

    public static DynamicArrayNumbers ArrayToDynamicArrayNumbers(double[] array) {
        DynamicArrayNumbers da = new DynamicArrayNumbers();
        da.array = arrays.CopyNumberArray(array);
        da.length = array.length;
        return da;
    }

    public static boolean DynamicArrayNumbersEqual(DynamicArrayNumbers a, DynamicArrayNumbers b) {
        boolean equal = true;
        if (a.length == b.length) {
            for (double i = 0.0; i < a.length && equal; i += 1.0) {
                if (a.array[(int)i] == b.array[(int)i]) continue;
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static LinkedListNumbers DynamicArrayNumbersToLinkedList(DynamicArrayNumbers da) {
        LinkedListNumbers ll = LinkedListNumbersFunctions.CreateLinkedListNumbers();
        for (double i = 0.0; i < da.length; i += 1.0) {
            LinkedListNumbersFunctions.LinkedListAddNumber(ll, da.array[(int)i]);
        }
        return ll;
    }

    public static DynamicArrayNumbers LinkedListToDynamicArrayNumbers(LinkedListNumbers ll) {
        LinkedListNodeNumbers node = ll.first;
        DynamicArrayNumbers da = new DynamicArrayNumbers();
        da.length = LinkedListNumbersFunctions.LinkedListNumbersLength(ll);
        da.array = new double[(int)da.length];
        for (double i = 0.0; i < da.length; i += 1.0) {
            da.array[(int)i] = node.value;
            node = node.next;
        }
        return da;
    }

    public static void delete(Object object) {
    }
}

