/*
 * Decompiled with CFR 0.152.
 */
package com.progsbase.libraries.JSON;

import JSON.StringElementMaps.StringElementMaps;
import JSON.json.json;
import JSON.structures.Element;
import JSON.writer.writer;
import com.progsbase.libraries.JSON.JSONException;
import com.progsbase.libraries.JSON.StringReference;
import java.lang.reflect.Field;
import java.util.List;

public class JSONReflectiveWriter {
    public static <T> boolean writeJSON(T t, StringReference jsonReference, StringReference errorMessage) {
        boolean success;
        try {
            jsonReference.string = JSONReflectiveWriter.writeJSON(t);
            success = true;
        }
        catch (JSONException e) {
            success = false;
            errorMessage.string = e.getMessage();
        }
        return success;
    }

    public static <T> String writeJSON(T t) throws JSONException {
        Element e = JSONReflectiveWriter.unjavaifyJSONValue(t);
        char[] value = writer.WriteJSON(e);
        return new String(value);
    }

    private static <T> Element unjavaifyJSONValue(T t) throws JSONException {
        Element e;
        if (t == null) {
            e = json.CreateNullElement();
        } else if (t.getClass().isArray()) {
            e = JSONReflectiveWriter.unjavaifyJSONArrayArray(t);
        } else if (t.getClass().isEnum()) {
            e = JSONReflectiveWriter.unjavaifyJSONEnum(t);
        } else if (t instanceof List) {
            e = JSONReflectiveWriter.unjavaifyJSONArrayList(t);
        } else if (t instanceof String) {
            String s = (String)t;
            e = json.CreateStringElement(s.toCharArray());
        } else if (t instanceof Double) {
            Double n = (Double)t;
            e = json.CreateNumberElement(n);
        } else if (t instanceof Float) {
            Float n = (Float)t;
            e = json.CreateNumberElement(n.floatValue());
        } else if (t instanceof Integer) {
            Integer n = (Integer)t;
            e = json.CreateNumberElement(n.intValue());
        } else if (t instanceof Long) {
            Long n = (Long)t;
            e = json.CreateNumberElement(n.longValue());
        } else if (t instanceof Short) {
            Short n = (Short)t;
            e = json.CreateNumberElement(n.shortValue());
        } else if (t instanceof Byte) {
            Byte n = (Byte)t;
            e = json.CreateNumberElement(n.byteValue());
        } else if (t instanceof Boolean) {
            Boolean b = (Boolean)t;
            e = json.CreateBooleanElement(b);
        } else {
            e = JSONReflectiveWriter.unjavaifyJSONObject(t);
        }
        return e;
    }

    private static <T> Element unjavaifyJSONEnum(T t) {
        return json.CreateStringElement(t.toString().toCharArray());
    }

    public static <T> Element unjavaifyJSONObject(T t) throws JSONException {
        Field[] fields = t.getClass().getFields();
        Element e = json.CreateObjectElement(fields.length);
        int i = 0;
        for (Field f : fields) {
            Element s;
            try {
                s = JSONReflectiveWriter.unjavaifyJSONValue(f.get(t));
            }
            catch (IllegalAccessException ex) {
                throw new JSONException(ex.getMessage());
            }
            StringElementMaps.SetStringElementMap(e.object, i, f.getName().toCharArray(), s);
            ++i;
        }
        return e;
    }

    public static Element unjavaifyJSONArrayList(Object o) throws JSONException {
        List l = (List)o;
        Element e = json.CreateArrayElement(l.size());
        int i = 0;
        for (Object p : l) {
            Element s;
            e.array[i] = s = JSONReflectiveWriter.unjavaifyJSONValue(p);
            ++i;
        }
        return e;
    }

    public static Element unjavaifyJSONArrayArray(Object o) throws JSONException {
        Object[] a = (Object[])o;
        Element e = json.CreateArrayElement(a.length);
        int i = 0;
        for (Object p : a) {
            Element s;
            e.array[i] = s = JSONReflectiveWriter.unjavaifyJSONValue(p);
            ++i;
        }
        return e;
    }
}

