/*
 * Decompiled with CFR 0.152.
 */
package arrays.arrays;

import references.references.BooleanArrayReference;
import references.references.NumberArrayReference;
import references.references.StringArrayReference;
import references.references.StringReference;

public class arrays {
    public static double[] StringToNumberArray(char[] string) {
        double[] array = new double[string.length];
        for (double i = 0.0; i < (double)string.length; i += 1.0) {
            array[(int)i] = string[(int)i];
        }
        return array;
    }

    public static char[] NumberArrayToString(double[] array) {
        char[] string = new char[array.length];
        for (double i = 0.0; i < (double)array.length; i += 1.0) {
            string[(int)i] = (char)array[(int)i];
        }
        return string;
    }

    public static boolean NumberArraysEqual(double[] a, double[] b) {
        boolean equal = true;
        if (a.length == b.length) {
            for (double i = 0.0; i < (double)a.length && equal; i += 1.0) {
                if (a[(int)i] == b[(int)i]) continue;
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static boolean BooleanArraysEqual(boolean[] a, boolean[] b) {
        boolean equal = true;
        if (a.length == b.length) {
            for (double i = 0.0; i < (double)a.length && equal; i += 1.0) {
                if (a[(int)i] == b[(int)i]) continue;
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static boolean StringsEqual(char[] a, char[] b) {
        boolean equal = true;
        if (a.length == b.length) {
            for (double i = 0.0; i < (double)a.length && equal; i += 1.0) {
                if (a[(int)i] == b[(int)i]) continue;
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static void FillNumberArray(double[] a, double value) {
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            a[(int)i] = value;
        }
    }

    public static void FillString(char[] a, char value) {
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            a[(int)i] = value;
        }
    }

    public static void FillBooleanArray(boolean[] a, boolean value) {
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            a[(int)i] = value;
        }
    }

    public static boolean FillNumberArrayRange(double[] a, double value, double from, double to) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            for (double i = 0.0; i < length; i += 1.0) {
                a[(int)(from + i)] = value;
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static boolean FillBooleanArrayRange(boolean[] a, boolean value, double from, double to) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            for (double i = 0.0; i < length; i += 1.0) {
                a[(int)(from + i)] = value;
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static boolean FillStringRange(char[] a, char value, double from, double to) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            for (double i = 0.0; i < length; i += 1.0) {
                a[(int)(from + i)] = value;
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static double[] CopyNumberArray(double[] a) {
        double[] n = new double[a.length];
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            n[(int)i] = a[(int)i];
        }
        return n;
    }

    public static boolean[] CopyBooleanArray(boolean[] a) {
        boolean[] n = new boolean[a.length];
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            n[(int)i] = a[(int)i];
        }
        return n;
    }

    public static char[] CopyString(char[] a) {
        char[] n = new char[a.length];
        for (double i = 0.0; i < (double)a.length; i += 1.0) {
            n[(int)i] = a[(int)i];
        }
        return n;
    }

    public static boolean CopyNumberArrayRange(double[] a, double from, double to, NumberArrayReference copyReference) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            double[] n = new double[(int)length];
            for (double i = 0.0; i < length; i += 1.0) {
                n[(int)i] = a[(int)(from + i)];
            }
            copyReference.numberArray = n;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static boolean CopyBooleanArrayRange(boolean[] a, double from, double to, BooleanArrayReference copyReference) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            boolean[] n = new boolean[(int)length];
            for (double i = 0.0; i < length; i += 1.0) {
                n[(int)i] = a[(int)(from + i)];
            }
            copyReference.booleanArray = n;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static boolean CopyStringRange(char[] a, double from, double to, StringReference copyReference) {
        boolean success;
        if (from >= 0.0 && from <= (double)a.length && to >= 0.0 && to <= (double)a.length && from <= to) {
            double length = to - from;
            char[] n = new char[(int)length];
            for (double i = 0.0; i < length; i += 1.0) {
                n[(int)i] = a[(int)(from + i)];
            }
            copyReference.string = n;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static boolean IsLastElement(double length, double index) {
        return index + 1.0 == length;
    }

    public static double[] CreateNumberArray(double length, double value) {
        double[] array = new double[(int)length];
        arrays.FillNumberArray(array, value);
        return array;
    }

    public static boolean[] CreateBooleanArray(double length, boolean value) {
        boolean[] array = new boolean[(int)length];
        arrays.FillBooleanArray(array, value);
        return array;
    }

    public static char[] CreateString(double length, char value) {
        char[] array = new char[(int)length];
        arrays.FillString(array, value);
        return array;
    }

    public static void SwapElementsOfNumberArray(double[] A, double ai, double bi) {
        double tmp = A[(int)ai];
        A[(int)ai] = A[(int)bi];
        A[(int)bi] = tmp;
    }

    public static void SwapElementsOfStringArray(StringArrayReference A, double ai, double bi) {
        StringReference tmp = A.stringArray[(int)ai];
        A.stringArray[(int)ai] = A.stringArray[(int)bi];
        A.stringArray[(int)bi] = tmp;
    }

    public static void ReverseNumberArray(double[] array) {
        for (double i = 0.0; i < (double)array.length / 2.0; i += 1.0) {
            arrays.SwapElementsOfNumberArray(array, i, (double)array.length - i - 1.0);
        }
    }

    public static void delete(Object object) {
    }
}

