/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.PowerShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

class PowerShellCommandProcessor
implements Callable<String> {
    private static final String CRLF = "\r\n";
    private final BufferedReader reader;
    private final String name;
    private boolean closed = false;
    private boolean timeout = false;
    private boolean scriptMode = false;
    private final long maxWait;
    private final int waitPause;

    public PowerShellCommandProcessor(String name, InputStream inputStream, long maxWait, int waitPause, boolean scriptMode) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.name = name;
        this.maxWait = maxWait;
        this.waitPause = waitPause;
        this.scriptMode = scriptMode;
    }

    @Override
    public String call() throws IOException, InterruptedException {
        StringBuilder powerShellOutput = new StringBuilder();
        try {
            if (this.startReading()) {
                this.readData(powerShellOutput);
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error reading PowerShell output", ioe);
            return ioe.getMessage();
        }
        catch (Exception e) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error reading PowerShell output", e);
        }
        return powerShellOutput.toString();
    }

    private void readData(StringBuilder powerShellOutput) throws IOException {
        String line;
        while (!(null == (line = this.reader.readLine()) || this.scriptMode && line.equals("--END-JPOWERSHELL-SCRIPT--"))) {
            powerShellOutput.append(line).append(CRLF);
            if (this.scriptMode) continue;
            try {
                if (this.continueReading() && !this.closed) continue;
                break;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PowerShellCommandProcessor.class.getName()).log(Level.SEVERE, "Error executing command and reading result", ex);
            }
        }
    }

    private boolean startReading() throws IOException, InterruptedException {
        int timeWaiting = 0;
        while (!this.reader.ready()) {
            Thread.sleep(this.waitPause);
            if ((long)(timeWaiting += this.waitPause) <= this.maxWait && !this.closed) continue;
            this.timeout = (long)timeWaiting > this.maxWait;
            return false;
        }
        return true;
    }

    private boolean continueReading() throws IOException, InterruptedException {
        Thread.sleep(this.waitPause);
        return this.reader.ready();
    }

    public void close() {
        this.closed = true;
    }

    public boolean isTimeout() {
        return this.timeout;
    }
}

