/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.wmi4java;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIException;
import com.profesorfalken.wmi4java.WMIStub;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;

class WMIVBScript
implements WMIStub {
    private static final String CRLF = "\r\n";

    WMIVBScript() {
    }

    private String executeScript(String scriptCode) throws WMIException {
        String scriptResponse = "";
        File tmpFile = null;
        OutputStreamWriter writer = null;
        try {
            String line;
            tmpFile = File.createTempFile("wmi4java" + new Date().getTime(), ".vbs");
            writer = new FileWriter(tmpFile);
            writer.write(scriptCode);
            writer.flush();
            writer.close();
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "cscript.exe", "/NoLogo", tmpFile.getAbsolutePath()});
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = processOutput.readLine()) != null) {
                if (line.isEmpty()) continue;
                scriptResponse = scriptResponse + line + CRLF;
            }
            if (scriptResponse.isEmpty()) {
                BufferedReader errorOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String errorResponse = "";
                while ((line = errorOutput.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    errorResponse = errorResponse + line + CRLF;
                }
                if (!errorResponse.isEmpty()) {
                    throw new WMIException("WMI operation finished in error: " + errorResponse);
                }
            }
        }
        catch (Exception ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (IOException ioe) {
                throw new WMIException(ioe.getMessage(), ioe);
            }
        }
        return scriptResponse.trim();
    }

    public String listClasses(String namespace, String computerName) throws WMIException {
        try {
            StringBuilder scriptCode = new StringBuilder(200);
            String namespaceCommand = "root/cimv2";
            if (!"*".equals(namespace)) {
                namespaceCommand = namespace;
            }
            scriptCode.append("Set objWMIService=GetObject(\"winmgmts:{impersonationLevel=impersonate}!\\\\").append(computerName).append("/").append(namespaceCommand).append("\")").append(CRLF);
            scriptCode.append("Set colClasses = objWMIService.SubclassesOf()").append(CRLF);
            scriptCode.append("For Each objClass in colClasses").append(CRLF);
            scriptCode.append("For Each objClassQualifier In objClass.Qualifiers_").append(CRLF);
            scriptCode.append("WScript.Echo objClass.Path_.Class").append(CRLF);
            scriptCode.append("Next").append(CRLF);
            scriptCode.append("Next").append(CRLF);
            return this.executeScript(scriptCode.toString());
        }
        catch (Exception ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
    }

    public String listProperties(String wmiClass, String namespace, String computerName) throws WMIException {
        try {
            StringBuilder scriptCode = new StringBuilder(200);
            String namespaceCommand = "root/cimv2";
            if (!"*".equals(namespace)) {
                namespaceCommand = namespace;
            }
            scriptCode.append("Set objWMIService=GetObject(\"winmgmts:{impersonationLevel=impersonate}!\\\\").append(computerName).append("/").append(namespaceCommand).append(":").append(wmiClass).append("\")").append(CRLF);
            scriptCode.append("For Each objClassProperty In objWMIService.Properties_").append(CRLF);
            scriptCode.append("WScript.Echo objClassProperty.Name").append(CRLF);
            scriptCode.append("Next").append(CRLF);
            return this.executeScript(scriptCode.toString());
        }
        catch (Exception ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
    }

    public String listObject(String wmiClass, String namespace, String computerName) throws WMIException {
        List<String> wmiProperties = WMI4Java.get().computerName(computerName).namespace(namespace).listProperties(wmiClass);
        try {
            StringBuilder scriptCode = new StringBuilder(200);
            String namespaceCommand = "root/cimv2";
            if (!"*".equals(namespace)) {
                namespaceCommand = namespace;
            }
            scriptCode.append("Set objWMIService=GetObject(\"winmgmts:{impersonationLevel=impersonate}!\\\\").append(computerName).append("/").append(namespaceCommand).append("\")").append(CRLF);
            scriptCode.append("Set colClasses = objWMIService.SubclassesOf()").append(CRLF);
            scriptCode.append("Set wmiQueryData = objWMIService.ExecQuery(\"Select * from ").append(wmiClass).append("\")").append(CRLF);
            scriptCode.append("For Each element In wmiQueryData").append(CRLF);
            for (String wmiProperty : wmiProperties) {
                scriptCode.append("Wscript.Echo \"").append(wmiProperty).append(": \" & ").append("element.").append(wmiProperty).append(CRLF);
            }
            scriptCode.append("Next").append(CRLF);
            return this.executeScript(scriptCode.toString());
        }
        catch (Exception ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
    }
}

