/*
 * Decompiled with CFR 0.152.
 */
package com.premiumminds.webapp.utils.mailer;

import com.premiumminds.webapp.utils.mailer.AbstractMailer;
import com.premiumminds.webapp.utils.mailer.MailerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SimpleMailer
extends AbstractMailer {
    private Address from;
    private String[] filenames;

    public SimpleMailer() {
    }

    public SimpleMailer(String from) {
        try {
            this.from = SimpleMailer.convertStringToAddress(from);
        }
        catch (MailerException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean isValidMailerConfiguration(Properties config) {
        return true;
    }

    @Override
    public void send(String to, String subject, String body) throws MailerException {
        this.send(to, null, subject, body);
    }

    @Override
    public void send(String to, Map<String, String> headers, String subject, String body) throws MailerException {
        ArrayList<String> tos = new ArrayList<String>();
        tos.add(to);
        this.send(tos, null, null, headers, subject, body);
    }

    @Override
    public void send(Collection<String> to, Collection<String> ccs, Collection<String> bccs, String subject, String body) throws MailerException {
        this.send(to, ccs, null, null, subject, body);
    }

    @Override
    public void send(Collection<String> to, Collection<String> ccs, Collection<String> bccs, Map<String, String> headers, String subject, String body) throws MailerException {
        if (!this.isValidConfiguration(SimpleMailer.getConfiguration())) {
            throw new MailerException("Mailer was not configured");
        }
        MimeMessage message = this.buildMessage(to, ccs, bccs, headers, subject, body);
        this.send(message);
    }

    @Override
    public void send(MimeMessage message) throws MailerException {
        Session session = Session.getDefaultInstance((Properties)SimpleMailer.getConfiguration());
        if (this.from != null) {
            try {
                message.setFrom(this.from);
            }
            catch (MessagingException e) {
                throw new MailerException(e);
            }
        }
        try {
            Transport tr = session.getTransport("smtp");
            if (SimpleMailer.getConfigurationProperty("mail.smtp.auth", "true").equalsIgnoreCase("true")) {
                tr.connect(SimpleMailer.getConfigurationProperty("mail.smtp.user"), SimpleMailer.getConfigurationProperty("mail.smtp.password"));
            } else {
                tr.connect();
            }
            tr.sendMessage((Message)message, message.getAllRecipients());
            tr.close();
        }
        catch (MessagingException e) {
            throw new MailerException(e);
        }
    }

    protected MimeMessage buildMessage(Collection<String> to, Collection<String> ccs, Collection<String> bccs, Map<String, String> headers, String subject, String body) throws MailerException {
        Session session = Session.getDefaultInstance((Properties)SimpleMailer.getConfiguration());
        MimeMessage message = new MimeMessage(session);
        try {
            if (this.isDebug()) {
                for (InternetAddress internetAddress : SimpleMailer.convertStringsToAddressess(SimpleMailer.getList(this.getDebugAddress()))) {
                    message.addRecipient(Message.RecipientType.TO, (Address)internetAddress);
                }
            } else {
                for (String string : to) {
                    message.addRecipient(Message.RecipientType.TO, (Address)SimpleMailer.convertStringToAddress(string));
                }
                if (ccs != null) {
                    for (String string : ccs) {
                        message.addRecipient(Message.RecipientType.CC, (Address)SimpleMailer.convertStringToAddress(string));
                    }
                }
                if (bccs != null) {
                    for (String string : bccs) {
                        message.addRecipient(Message.RecipientType.BCC, (Address)SimpleMailer.convertStringToAddress(string));
                    }
                }
            }
            message.setSubject(subject);
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)body, "text/plain; charset=\"utf-8\"");
            mp.addBodyPart((BodyPart)mimeBodyPart);
            if (null != this.getAttachmentsFiles()) {
                for (String filename : this.getAttachmentsFiles()) {
                    FileDataSource source = new FileDataSource(filename);
                    MimeBodyPart messageAttachment = new MimeBodyPart();
                    messageAttachment.setDataHandler(new DataHandler((DataSource)source));
                    messageAttachment.setFileName(filename);
                    mp.addBodyPart((BodyPart)messageAttachment);
                }
            }
            message.setContent((Multipart)mp);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    message.addHeader(key, headers.get(key));
                    message.setHeader(key, headers.get(key));
                }
            }
            message.saveChanges();
        }
        catch (MailerException e) {
            throw new MailerException(e);
        }
        catch (MessagingException e) {
            throw new MailerException(e);
        }
        return message;
    }

    private String[] getAttachmentsFiles() {
        return this.filenames;
    }

    public void attachFile(String[] files) {
        this.filenames = files;
    }
}

