/*
 * Decompiled with CFR 0.152.
 */
package com.premiumminds.webapp.utils.mailer;

import com.premiumminds.webapp.utils.mailer.MIMEMessageConfigurator;
import com.premiumminds.webapp.utils.mailer.MailerException;
import com.premiumminds.webapp.utils.mailer.SimpleMailer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendGridMailer
extends SimpleMailer {
    public void send(String to, String subject, String body, String sendGridHeaders, MIMEMessageConfigurator config) throws MailerException {
        ArrayList<String> tos = new ArrayList<String>(1);
        tos.add(to);
        this.send(tos, null, null, null, subject, body, sendGridHeaders, config);
    }

    public void send(String to, String subject, String body, String sendGridHeaders) throws MailerException {
        this.send(to, null, subject, body, sendGridHeaders);
    }

    public void send(String to, Map<String, String> headers, String subject, String body, String sendGridHeaders) throws MailerException {
        ArrayList<String> tos = new ArrayList<String>(1);
        tos.add(to);
        this.send(tos, null, null, headers, subject, body, sendGridHeaders);
    }

    public void send(Collection<String> to, Collection<String> ccs, Collection<String> bccs, String subject, String body, String sendGridHeaders) throws MailerException {
        this.send(to, ccs, bccs, null, subject, body, sendGridHeaders);
    }

    public void send(Collection<String> to, Collection<String> ccs, Collection<String> bccs, Map<String, String> headers, String subject, String body, String sendGridHeaders) throws MailerException {
        MimeMessage message = this.buildMessage(to, ccs, bccs, headers, subject, body);
        this.send(message, sendGridHeaders);
    }

    public void send(Collection<String> to, Collection<String> ccs, Collection<String> bccs, Map<String, String> headers, String subject, String body, String sendGridHeaders, MIMEMessageConfigurator config) throws MailerException {
        MimeMessage message = this.buildMessage(to, ccs, bccs, headers, subject, body);
        MimeMessage toSend = null == config ? message : config.configure(message);
        this.send(toSend, sendGridHeaders);
    }

    @Override
    public void send(MimeMessage message) throws MailerException {
        this.send(message, null);
    }

    public void send(MimeMessage message, String sendGridHeaders) throws MailerException {
        Session session = Session.getDefaultInstance((Properties)SendGridMailer.getConfiguration());
        try {
            Transport tr = session.getTransport("smtp");
            if (message.getFrom() == null && null != SendGridMailer.getConfigurationProperty("mail.smtp.from")) {
                message.setFrom((Address)new InternetAddress(SendGridMailer.getConfigurationProperty("mail.smtp.from")));
            }
            if (SendGridMailer.getConfigurationProperty("mail.smtp.auth", "true").equalsIgnoreCase("true")) {
                tr.connect(SendGridMailer.getConfigurationProperty("mail.smtp.user"), SendGridMailer.getConfigurationProperty("mail.smtp.password"));
            } else {
                tr.connect();
            }
            message = this.appendSendGridHeaders(message, sendGridHeaders);
            tr.sendMessage((Message)message, message.getAllRecipients());
            tr.close();
        }
        catch (MessagingException e) {
            throw new MailerException(e);
        }
    }

    protected MimeMessage appendSendGridHeaders(MimeMessage message, String headers) throws MessagingException {
        message.addHeader("X-SMTPAPI", this.formatSendGridHeaders(headers));
        return message;
    }

    private String formatSendGridHeaders(String headers) {
        return headers;
    }
}

