/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.concurrent;

import android.os.Binder;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicCallable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicConcurrent;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicHandler;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicResult;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicRunnable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicStatus;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DynamicTask<T, P, R>
extends DynamicRunnable<T, P, R> {
    private final DynamicHandler<P, R> mHandler;
    private final DynamicCallable<T, DynamicResult<R>> mWorker;
    private final FutureTask<DynamicResult<R>> mFuture;
    private volatile DynamicStatus mStatus = DynamicStatus.PENDING;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    public DynamicTask() {
        this(Looper.getMainLooper());
    }

    public DynamicTask(@NonNull Looper looper) {
        this.mHandler = new DynamicHandler(looper, this);
        this.mWorker = new DynamicCallable<T, DynamicResult<R>>(){

            @Override
            public DynamicResult<R> call() {
                DynamicTask.this.mTaskInvoked.set(true);
                DynamicResult result = null;
                try {
                    Process.setThreadPriority((int)10);
                    result = new DynamicResult.Success(DynamicTask.this.doInBackground(this.getParams()));
                    Binder.flushPendingCommands();
                }
                catch (Exception e) {
                    DynamicTask.this.mCancelled.set(true);
                    result = new DynamicResult.Error(e);
                }
                finally {
                    DynamicTask.this.postResult(result);
                }
                return result;
            }
        };
        this.mFuture = new FutureTask<DynamicResult<R>>(this.mWorker){

            @Override
            protected void done() {
                try {
                    DynamicTask.this.postResultIfNotInvoked((DynamicResult)this.get());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    DynamicTask.this.postResultIfNotInvoked(null);
                }
            }
        };
    }

    private void postResultIfNotInvoked(@Nullable DynamicResult<R> result) {
        if (!this.mTaskInvoked.get()) {
            this.postResult(result);
        }
    }

    @Nullable
    private DynamicResult<R> postResult(@Nullable DynamicResult<R> result) {
        this.getHandler().obtainMessage(1, result).sendToTarget();
        return result;
    }

    @NonNull
    public DynamicHandler<P, R> getHandler() {
        return this.mHandler;
    }

    public boolean getBooleanResult(@Nullable DynamicResult<R> result) {
        Boolean success = null;
        if (result instanceof DynamicResult.Success && result.getData() instanceof Boolean) {
            success = (Boolean)result.getData();
        }
        return success != null && success != false;
    }

    @NonNull
    public final DynamicStatus getStatus() {
        return this.mStatus;
    }

    @Nullable
    public final DynamicResult<R> get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    @Nullable
    public final DynamicResult<R> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    @Nullable
    public DynamicResult<P> publishProgress(@Nullable DynamicResult<P> progress) {
        this.getHandler().obtainMessage(2, progress).sendToTarget();
        return progress;
    }

    @Override
    public void finish(@Nullable DynamicResult<R> result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = DynamicStatus.FINISHED;
    }

    @Override
    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled()) {
            return false;
        }
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    @MainThread
    @NonNull
    public final DynamicTask<T, P, R> executeOnExecutor(@NonNull Executor executor, @Nullable T params) {
        if (this.mStatus != DynamicStatus.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = DynamicStatus.RUNNING;
        this.onPreExecute();
        this.mWorker.setParams(params);
        executor.execute(this.mFuture);
        return this;
    }

    @MainThread
    @NonNull
    public final DynamicTask<T, P, R> executeOnExecutor(@NonNull Executor executor) {
        return this.executeOnExecutor(executor, null);
    }

    @MainThread
    @NonNull
    public final DynamicTask<T, P, R> execute(@Nullable T params) {
        return this.executeOnExecutor(DynamicConcurrent.getInstance().getThreadPoolExecutor(), params);
    }

    @MainThread
    @NonNull
    public final DynamicTask<T, P, R> execute() {
        return this.execute(null);
    }
}

