/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.cache;

import androidx.collection.LruCache;

public abstract class DynamicLruCache<T, V>
extends LruCache<T, V> {
    public static final int MAX_SIZE = 512;
    public static final int BYTE_MULTIPLIER = 1024;
    private final int mMaxSize;
    private final int mByteMultiplier;

    public DynamicLruCache() {
        this(512, 1024);
    }

    public DynamicLruCache(int maxSize, int byteMultiplier) {
        super(maxSize * byteMultiplier);
        this.mMaxSize = maxSize;
        this.mByteMultiplier = byteMultiplier;
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public int getByteMultiplier() {
        return this.mByteMultiplier;
    }
}

