/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.cache;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import com.pranavpandey.android.dynamic.util.cache.DynamicLruCache;

public final class DrawableLruCache<T>
extends DynamicLruCache<T, Drawable> {
    protected int sizeOf(@NonNull T key, @NonNull Drawable value) {
        if (value instanceof BitmapDrawable) {
            return ((BitmapDrawable)value).getBitmap().getByteCount() / this.getByteMultiplier();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)value.getIntrinsicWidth(), (int)value.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        value.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        value.draw(canvas);
        return bitmap.getByteCount() / this.getByteMultiplier();
    }
}

