/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Insets;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.WindowCompat;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import com.pranavpandey.android.dynamic.util.DynamicUnitUtils;

public class DynamicWindowUtils {
    @TargetApi(value=30)
    @Nullable
    public static Display getDisplay(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (DynamicSdkUtils.is30()) {
            try {
                return context.getDisplay();
            }
            catch (Exception ignored) {
                DisplayManager displayManager = (DisplayManager)ContextCompat.getSystemService((Context)context, DisplayManager.class);
                return displayManager != null ? displayManager.getDisplay(0) : null;
            }
        }
        WindowManager windowManager = context instanceof Activity ? ((Activity)context).getWindowManager() : (WindowManager)ContextCompat.getSystemService((Context)context, WindowManager.class);
        return windowManager != null ? windowManager.getDefaultDisplay() : null;
    }

    @Nullable
    public static DisplayMetrics getDisplayMetrics(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        return context.getResources().getDisplayMetrics();
    }

    @TargetApi(value=30)
    @Nullable
    public static WindowMetrics getCurrentWindowMetrics(@Nullable Context context) {
        if (!DynamicSdkUtils.is30() || context == null) {
            return null;
        }
        WindowManager windowManager = context instanceof Activity ? ((Activity)context).getWindowManager() : (WindowManager)ContextCompat.getSystemService((Context)context, WindowManager.class);
        return windowManager != null ? windowManager.getCurrentWindowMetrics() : null;
    }

    @TargetApi(value=17)
    public static float getDisplayDensity(@Nullable Context context) {
        if (context == null) {
            return Resources.getSystem().getDisplayMetrics().density;
        }
        return context.getResources().getDisplayMetrics().density;
    }

    @TargetApi(value=30)
    @NonNull
    public static Point getAppUsableScreenSize(@Nullable Context context) {
        Point size = new Point();
        if (DynamicSdkUtils.is31()) {
            WindowMetrics windowMetrics = DynamicWindowUtils.getCurrentWindowMetrics(context);
            if (windowMetrics != null) {
                Insets insets = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.navigationBars());
                size.x = windowMetrics.getBounds().width() - insets.left - insets.right;
                size.y = windowMetrics.getBounds().height() - insets.top - insets.bottom;
            }
        } else {
            Display display = DynamicWindowUtils.getDisplay(context);
            if (display != null) {
                size.x = display.getWidth();
                size.y = display.getHeight();
            }
        }
        return size;
    }

    @TargetApi(value=30)
    @NonNull
    public static Point getRealScreenSize(@Nullable Context context) {
        Point size = new Point();
        if (DynamicSdkUtils.is30()) {
            WindowMetrics windowMetrics = DynamicWindowUtils.getCurrentWindowMetrics(context);
            if (windowMetrics != null) {
                size.x = windowMetrics.getBounds().width();
                size.y = windowMetrics.getBounds().height();
            }
        } else if (DynamicSdkUtils.is17()) {
            Display display = DynamicWindowUtils.getDisplay(context);
            if (display != null) {
                display.getRealSize(size);
            }
        } else {
            DisplayMetrics displayMetrics = DynamicWindowUtils.getDisplayMetrics(context);
            if (displayMetrics != null) {
                size.x = displayMetrics.widthPixels;
                size.y = displayMetrics.heightPixels;
            }
        }
        return size;
    }

    public static int getStatusBarSize(@NonNull Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @NonNull
    public static Point getNavigationBarSize(@NonNull Context context) {
        Point appUsableSize = DynamicWindowUtils.getAppUsableScreenSize(context);
        Point realScreenSize = DynamicWindowUtils.getRealScreenSize(context);
        if (appUsableSize.x < realScreenSize.x) {
            return new Point(realScreenSize.x - appUsableSize.x, appUsableSize.y);
        }
        if (appUsableSize.y < realScreenSize.y) {
            return new Point(appUsableSize.x, realScreenSize.y - appUsableSize.y);
        }
        return new Point();
    }

    public static boolean isNavigationBarPresent(@NonNull Context context) {
        return !DynamicWindowUtils.getNavigationBarSize(context).equals(0, 0);
    }

    public static boolean isNavigationBarThemeSupported(@NonNull Context context) {
        return DynamicSdkUtils.is21() && DynamicWindowUtils.isNavigationBarPresent(context);
    }

    public static boolean isGestureNavigation(@NonNull Context context) {
        Point navigationBarSize = DynamicWindowUtils.getNavigationBarSize(context);
        return DynamicSdkUtils.is29() && navigationBarSize.y > 0 && navigationBarSize.y <= DynamicUnitUtils.convertDpToPixels(24.0f);
    }

    public static void setShowWallpaper(@Nullable Window window, boolean showWallpaper) {
        if (window == null) {
            return;
        }
        if (showWallpaper) {
            window.addFlags(0x100000);
        } else {
            window.clearFlags(0x100000);
        }
    }

    @TargetApi(value=30)
    public static void setEdgeToEdge(@Nullable Window window, boolean edgeToEdge) {
        if (window == null) {
            return;
        }
        WindowCompat.setDecorFitsSystemWindows((Window)window, (!edgeToEdge ? 1 : 0) != 0);
    }

    public static int getScreenOrientation(@Nullable Context context) {
        int orientation = -1;
        Display display = DynamicWindowUtils.getDisplay(context);
        DisplayMetrics displayMatrix = DynamicWindowUtils.getDisplayMetrics(context);
        if (display == null || displayMatrix == null) {
            return orientation;
        }
        float scale = displayMatrix.density;
        int rotation = display.getRotation();
        int width = (int)((float)displayMatrix.widthPixels * scale + 0.5f);
        int height = (int)((float)displayMatrix.heightPixels * scale + 0.5f);
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = 9;
                    break;
                }
                case 3: {
                    orientation = 8;
                    break;
                }
                default: {
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = 8;
                    break;
                }
                case 3: {
                    orientation = 9;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    @TargetApi(value=26)
    public static int getOverlayFlag(boolean alert, boolean accessibility) {
        if (DynamicSdkUtils.is22() && accessibility) {
            return 2032;
        }
        return DynamicSdkUtils.is26() ? 2038 : (alert ? 2003 : 2006);
    }

    @TargetApi(value=26)
    public static int getOverlayFlag(boolean alert) {
        return DynamicWindowUtils.getOverlayFlag(alert, false);
    }
}

