/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.app.ApplicationErrorReport;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.pranavpandey.android.dynamic.util.DynamicIntentUtils;
import com.pranavpandey.android.dynamic.util.DynamicPackageUtils;
import com.pranavpandey.android.dynamic.util.R;

public class DynamicLinkUtils {
    private static final String URL_MARKET = "market://details?id=";
    private static final String URL_PLAY_STORE = "http://play.google.com/store/apps/details?id=";
    private static final String URL_MARKET_SEARCH_PUB = "market://search?q=pub:";
    private static final String URL_GOOGLE_PLAY_SEARCH_PUB = "http://play.google.com/store/search?q=pub:";
    private static final String PACKAGE_FEEDBACK = "com.google.android.feedback";
    private static final String PACKAGE_GMS = "com.google.android.gms";

    public static boolean copyToClipboard(@NonNull Context context, @NonNull String label, @NonNull String text) {
        ClipboardManager clipboard = (ClipboardManager)ContextCompat.getSystemService((Context)context, ClipboardManager.class);
        if (clipboard != null) {
            clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)label, (CharSequence)text));
            return true;
        }
        return false;
    }

    public static boolean share(@Nullable Context context, @Nullable String title, @Nullable String message, @Nullable Uri uri, @Nullable String mimeType) {
        if (context == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.SEND");
        intent.addFlags(0x10000000);
        intent.setType("text/plain");
        if (title == null) {
            title = context.getResources().getString(R.string.adu_share_to);
        }
        if (message == null) {
            message = String.format(context.getString(R.string.adu_share_desc), context.getApplicationInfo().loadLabel(context.getPackageManager()), context.getPackageName());
        }
        intent.putExtra("android.intent.extra.TEXT", message);
        if (uri != null) {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            intent.setType(mimeType != null ? mimeType : "*/*");
            intent.addFlags(3);
        }
        if (DynamicIntentUtils.isActivityResolved(context, intent)) {
            context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)title));
            return true;
        }
        return false;
    }

    public static boolean share(@Nullable Context context, @Nullable String title, @Nullable String message, @Nullable Uri image) {
        return DynamicLinkUtils.share(context, title, message, image, "image/*");
    }

    public static boolean share(@Nullable Context context, @Nullable String title, @Nullable String message) {
        return DynamicLinkUtils.share(context, title, message, null);
    }

    public static boolean shareApp(@Nullable Context context) {
        return DynamicLinkUtils.share(context, null, null);
    }

    public static boolean viewUrl(@Nullable Context context, @Nullable String url) {
        try {
            return DynamicIntentUtils.viewIntent(context, new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean viewInGooglePlay(@Nullable Context context, @NonNull String packageName) {
        if (DynamicLinkUtils.viewUrl(context, URL_MARKET + packageName)) {
            return true;
        }
        return DynamicLinkUtils.viewUrl(context, URL_PLAY_STORE + packageName);
    }

    public static boolean rateApp(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        return DynamicLinkUtils.viewInGooglePlay(context, context.getPackageName());
    }

    public static boolean moreApps(@Nullable Context context, @NonNull String publisher) {
        if (DynamicLinkUtils.viewUrl(context, URL_MARKET_SEARCH_PUB + publisher)) {
            return true;
        }
        return DynamicLinkUtils.viewUrl(context, URL_GOOGLE_PLAY_SEARCH_PUB + publisher);
    }

    public static boolean email(@Nullable Context context, @NonNull String[] emails, @Nullable String subject, @Nullable String text) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.addFlags(0x10000000);
        intent.setData(Uri.parse((String)"mailto:"));
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", text);
        if (DynamicIntentUtils.isActivityResolved(context, intent)) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    public static boolean email(@Nullable Context context, @NonNull String email, @Nullable String subject, @Nullable String text) {
        return DynamicLinkUtils.email(context, new String[]{email}, subject, text);
    }

    public static boolean report(@Nullable Context context, @Nullable String appName, @NonNull String email, Boolean license) {
        if (context == null) {
            return false;
        }
        String versionName = null;
        int versionCode = 0;
        try {
            versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)128).versionName;
            versionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)128).versionCode;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (appName == null) {
            appName = context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
        }
        if (license != null) {
            return DynamicLinkUtils.email(context, email, String.format(context.getResources().getString(R.string.adu_report_title_license), appName, versionName, versionCode, license, Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE), context.getResources().getString(R.string.adu_bug_desc));
        }
        return DynamicLinkUtils.email(context, email, String.format(context.getResources().getString(R.string.adu_report_title), appName, versionName, versionCode, Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE), context.getResources().getString(R.string.adu_bug_desc));
    }

    public static boolean report(@Nullable Context context, @Nullable String appName, @NonNull String email) {
        return DynamicLinkUtils.report(context, appName, email, null);
    }

    public static boolean isEmailExists(@Nullable Context context) {
        return DynamicIntentUtils.isActivityResolved(context, new Intent("android.intent.action.SENDTO", Uri.parse((String)"mailto:")));
    }

    public static boolean isGMSExists(@Nullable Context context) {
        return DynamicPackageUtils.isPackageExists(context, PACKAGE_GMS);
    }

    public static boolean isGoogleFeedbackExists(@Nullable Context context) {
        return DynamicPackageUtils.isPackageExists(context, PACKAGE_FEEDBACK);
    }

    public static boolean isFeedbackExists(@Nullable Context context) {
        return DynamicLinkUtils.isGMSExists(context) || DynamicLinkUtils.isGoogleFeedbackExists(context);
    }

    public static boolean feedback(@Nullable Context context, @Nullable String appName, @NonNull String email, int reportType, @Nullable ApplicationErrorReport.CrashInfo crashInfo) {
        if (context == null) {
            return false;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = report.processName = context.getPackageName();
        report.time = System.currentTimeMillis();
        report.type = reportType;
        report.systemApp = DynamicPackageUtils.isSystemApp(context.getApplicationInfo());
        if (crashInfo != null) {
            report.crashInfo = crashInfo;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.BUG_REPORT", (Parcelable)report);
        if (DynamicLinkUtils.isGMSExists(context)) {
            intent.setClassName(PACKAGE_GMS, "com.google.android.gms.feedback.FeedbackActivity");
        } else {
            intent.setClassName(PACKAGE_FEEDBACK, "com.google.android.feedback.FeedbackActivity");
        }
        if (DynamicIntentUtils.viewIntent(context, intent)) {
            return true;
        }
        return DynamicLinkUtils.report(context, appName, email);
    }

    public static boolean feedback(@Nullable Context context, @Nullable String appName, @NonNull String email) {
        return DynamicLinkUtils.feedback(context, appName, email, 0, null);
    }
}

