/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class CustomDateDeserializer
extends StdDeserializer<Date> {
    private static final long serialVersionUID = 1L;
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd"};
    private static final Locale DATE_LOCALE = Locale.ENGLISH;

    public CustomDateDeserializer() {
        this(null);
    }

    public CustomDateDeserializer(Class<?> vc) {
        super(vc);
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String date = node.textValue();
        for (String DATE_FORMAT : DATE_FORMATS) {
            try {
                return new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE).parse(date);
            }
            catch (ParseException parseException) {
            }
        }
        throw new JsonParseException(jsonParser, this.getParsingErrorMessage(date));
    }

    private String getParsingErrorMessage(String date) {
        return "Not parsable date: \"" + date + "\". Supported formats: " + Arrays.toString(DATE_FORMATS);
    }
}

