/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import com.postmarkapp.postmark.client.data.DataHandler;
import com.postmarkapp.postmark.client.data.model.PostmarkError;
import com.postmarkapp.postmark.client.exception.InternalServerException;
import com.postmarkapp.postmark.client.exception.InvalidAPIKeyException;
import com.postmarkapp.postmark.client.exception.InvalidMessageException;
import com.postmarkapp.postmark.client.exception.PostmarkException;
import com.postmarkapp.postmark.client.exception.TimeoutException;
import com.postmarkapp.postmark.client.exception.UnknownException;
import java.io.IOException;

public class HttpClientErrorHandler {
    protected final DataHandler dataHandler;

    public HttpClientErrorHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public PostmarkException throwErrorBasedOnStatusCode(Integer statusCode, String message) throws IOException {
        switch (statusCode) {
            case 401: {
                return new InvalidAPIKeyException(this.postmarkErrorFromResponse(message));
            }
            case 408: {
                return new TimeoutException(message);
            }
            case 422: {
                return new InvalidMessageException(this.postmarkErrorFromResponse(message));
            }
            case 500: {
                return new InternalServerException(message);
            }
        }
        return new UnknownException(message);
    }

    private PostmarkError postmarkErrorFromResponse(String message) throws IOException {
        return this.dataHandler.fromJson(message, PostmarkError.class);
    }
}

