/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class HttpClient {
    private final MultivaluedMap<String, Object> headers;
    private final Client client;

    public HttpClient(MultivaluedMap<String, Object> headers, int connectTimeoutSeconds, int readTimeoutSeconds) {
        this(headers);
        this.setConnectTimeoutSeconds(connectTimeoutSeconds);
        this.setReadTimeoutSeconds(readTimeoutSeconds);
    }

    public HttpClient(MultivaluedMap<String, Object> headers) {
        this.headers = headers;
        this.client = ClientBuilder.newClient();
        this.setReadTimeoutSeconds(DEFAULTS.READ_TIMEOUT_SECONDS.value);
        this.setConnectTimeoutSeconds(DEFAULTS.CONNECT_TIMEOUT_SECONDS.value);
    }

    public ClientResponse execute(REQUEST_TYPES requestType, String url, String data) {
        Response response;
        WebTarget target = this.client.target(url);
        switch (requestType) {
            case POST: {
                response = (Response)target.request().headers(this.headers).post(Entity.json((Object)data), Response.class);
                break;
            }
            case GET: {
                response = (Response)target.request().headers(this.headers).get(Response.class);
                break;
            }
            case PUT: {
                response = (Response)target.request().headers(this.headers).put(Entity.json((Object)data), Response.class);
                break;
            }
            case PATCH: {
                target.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
                response = (Response)target.request().headers(this.headers).method("PATCH", Entity.json((Object)data), Response.class);
                break;
            }
            case DELETE: {
                response = (Response)target.request().headers(this.headers).delete(Response.class);
                break;
            }
            default: {
                response = (Response)target.request().headers(this.headers).get(Response.class);
            }
        }
        return this.prettifyResponse(response);
    }

    public ClientResponse execute(REQUEST_TYPES request_type, String url) {
        return this.execute(request_type, url, null);
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.client.property("jersey.config.client.connectTimeout", (Object)(connectTimeoutSeconds * 1000));
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.client.property("jersey.config.client.readTimeout", (Object)(readTimeoutSeconds * 1000));
    }

    public Client getClient() {
        return this.client;
    }

    private ClientResponse prettifyResponse(Response response) {
        return new ClientResponse(response.getStatus(), (String)response.readEntity(String.class));
    }

    public static enum REQUEST_TYPES {
        POST,
        GET,
        PUT,
        PATCH,
        DELETE;

    }

    public class ClientResponse {
        private final int code;
        private final String message;

        public ClientResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum DEFAULTS {
        CONNECT_TIMEOUT_SECONDS(5),
        READ_TIMEOUT_SECONDS(15);

        public final int value;

        private DEFAULTS(int value) {
            this.value = value;
        }
    }
}

