/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import com.postmarkapp.postmark.client.BaseApiClient;
import com.postmarkapp.postmark.client.HttpClient;
import com.postmarkapp.postmark.client.Parameters;
import com.postmarkapp.postmark.client.data.model.RequestResponse;
import com.postmarkapp.postmark.client.data.model.domains.Domain;
import com.postmarkapp.postmark.client.data.model.domains.DomainDetails;
import com.postmarkapp.postmark.client.data.model.domains.Domains;
import com.postmarkapp.postmark.client.data.model.senders.SignatureDetails;
import com.postmarkapp.postmark.client.data.model.senders.SignatureToCreate;
import com.postmarkapp.postmark.client.data.model.senders.Signatures;
import com.postmarkapp.postmark.client.data.model.server.Server;
import com.postmarkapp.postmark.client.data.model.servers.Servers;
import com.postmarkapp.postmark.client.data.model.templates.TemplatesPush;
import com.postmarkapp.postmark.client.data.model.templates.TemplatesPushRequest;
import com.postmarkapp.postmark.client.exception.PostmarkException;
import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;

public class AccountApiClient
extends BaseApiClient {
    private final String serversEndpoint = "/servers/";
    private final String domainsEndpoint = "/domains/";
    private final String sendersEndpoint = "/senders/";

    public AccountApiClient(String baseUrl, MultivaluedMap<String, Object> headers) {
        super(baseUrl, headers);
    }

    public AccountApiClient(String baseUrl, MultivaluedMap<String, Object> headers, boolean secureConnection) {
        super(baseUrl, headers, secureConnection);
    }

    public Server getServers(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/servers/" + id));
        return this.dataHandler.fromJson(response, Server.class);
    }

    public Server createServer(Server data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/servers/"), data);
        return this.dataHandler.fromJson(response, Server.class);
    }

    public Server setServer(Integer id, Server data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/servers/" + id), data);
        return this.dataHandler.fromJson(response, Server.class);
    }

    public Servers getServers(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/servers/" + parameters));
        return this.dataHandler.fromJson(response, Servers.class);
    }

    public RequestResponse deleteServer(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/servers/" + id));
        return this.dataHandler.fromJson(response, RequestResponse.class);
    }

    public Domains getDomains(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/domains/" + parameters));
        return this.dataHandler.fromJson(response, Domains.class);
    }

    public DomainDetails getDomainDetails(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/domains/" + id));
        return this.dataHandler.fromJson(response, DomainDetails.class);
    }

    public DomainDetails createDomain(Domain domain) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/domains/"), domain);
        return this.dataHandler.fromJson(response, DomainDetails.class);
    }

    public DomainDetails setDomain(Integer id, DomainDetails domain) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/domains/" + id), domain);
        return this.dataHandler.fromJson(response, DomainDetails.class);
    }

    public String deleteDomain(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/domains/" + id));
    }

    public DomainDetails verifyDomainDKIM(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/domains/" + id + "/verifyDKIM"));
        return this.dataHandler.fromJson(response, DomainDetails.class);
    }

    public DomainDetails verifyDomainReturnPath(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/domains/" + id + "/verifyReturnPath"));
        return this.dataHandler.fromJson(response, DomainDetails.class);
    }

    public String verifyDomainSPF(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/domains/" + id + "/verifySPF"));
    }

    public String rotateDomainDKIM(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/domains/" + id + "/rotateDKIM"));
    }

    public Signatures getSenderSignatures(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/senders/" + parameters));
        return this.dataHandler.fromJson(response, Signatures.class);
    }

    public SignatureDetails getSenderSignatureDetails(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/senders/" + id));
        return this.dataHandler.fromJson(response, SignatureDetails.class);
    }

    public SignatureDetails createSenderSignature(SignatureToCreate signature) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/senders/"), signature);
        return this.dataHandler.fromJson(response, SignatureDetails.class);
    }

    public SignatureDetails setSenderSignature(Integer id, SignatureToCreate signature) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/senders/" + id), signature);
        return this.dataHandler.fromJson(response, SignatureDetails.class);
    }

    public String deleteSenderSignature(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/senders/" + id));
    }

    public String resendSenderSignatureConfirmation(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/senders/" + id + "/resend"));
    }

    public SignatureDetails verifySenderSignatureSPF(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/senders/" + id + "/verifySPF"));
        return this.dataHandler.fromJson(response, SignatureDetails.class);
    }

    public String requestSenderSignatureDKIM(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/senders/" + id + "/requestNewDKIM"));
    }

    public TemplatesPush pushTemplates(TemplatesPushRequest data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/templates/push"), data);
        return this.dataHandler.fromJson(response, TemplatesPush.class);
    }
}

