/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.internal.util.CheckerPermission;

@ClientScope
public class CheckerScanPermission {
    private final CheckerPermission checkerPermission;
    private final String[][] scanPermissions;

    @Inject
    CheckerScanPermission(CheckerPermission checkerPermission, @Named(value="scan-permissions") String[][] scanPermissions) {
        this.checkerPermission = checkerPermission;
        this.scanPermissions = scanPermissions;
    }

    public boolean isScanRuntimePermissionGranted() {
        boolean allNeededPermissionsGranted = true;
        for (String[] neededPermissions : this.scanPermissions) {
            allNeededPermissionsGranted &= this.checkerPermission.isAnyPermissionGranted(neededPermissions);
        }
        return allNeededPermissionsGranted;
    }

    public String[] getRecommendedScanRuntimePermissions() {
        int allPermissionsCount = 0;
        for (String[] permissionsArray : this.scanPermissions) {
            allPermissionsCount += permissionsArray.length;
        }
        String[] resultPermissions = new String[allPermissionsCount];
        int i = 0;
        String[][] stringArray = this.scanPermissions;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] permissionsArray;
            for (String permission2 : permissionsArray = stringArray[j]) {
                resultPermissions[i++] = permission2;
            }
        }
        return resultPermissions;
    }
}

