/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.operations.ScanOperationApi21;
import com.polidea.rxandroidble2.internal.scan.AndroidScanObjectsConverter;
import com.polidea.rxandroidble2.internal.scan.EmulatedScanFilterMatcher;
import com.polidea.rxandroidble2.internal.scan.InternalScanResultCreator;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.ScanFilterInterface;
import com.polidea.rxandroidble2.internal.scan.ScanSettingsEmulator;
import com.polidea.rxandroidble2.internal.scan.ScanSetup;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilder;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.scan.ScanFilter;
import com.polidea.rxandroidble2.scan.ScanSettings;
import io.reactivex.ObservableTransformer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ScanSetupBuilderImplApi23
implements ScanSetupBuilder {
    private final RxBleAdapterWrapper rxBleAdapterWrapper;
    private final InternalScanResultCreator internalScanResultCreator;
    private final ScanSettingsEmulator scanSettingsEmulator;
    private final AndroidScanObjectsConverter androidScanObjectsConverter;

    @Inject
    ScanSetupBuilderImplApi23(RxBleAdapterWrapper rxBleAdapterWrapper, InternalScanResultCreator internalScanResultCreator, ScanSettingsEmulator scanSettingsEmulator, AndroidScanObjectsConverter androidScanObjectsConverter) {
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
        this.internalScanResultCreator = internalScanResultCreator;
        this.scanSettingsEmulator = scanSettingsEmulator;
        this.androidScanObjectsConverter = androidScanObjectsConverter;
    }

    @Override
    @RequiresApi(value=21)
    public ScanSetup build(ScanSettings scanSettings, ScanFilter ... scanFilters) {
        boolean shouldEmulateCallbackType;
        boolean areFiltersSpecified = ScanSetupBuilderImplApi23.areFiltersSpecified(scanFilters);
        boolean isFilteringCallbackType = scanSettings.getCallbackType() != 1;
        Object resultTransformer = ObservableUtil.identityTransformer();
        ScanSettings resultScanSettings = scanSettings;
        boolean bl = shouldEmulateCallbackType = isFilteringCallbackType && !areFiltersSpecified;
        if (shouldEmulateCallbackType) {
            RxBleLog.d("ScanSettings.callbackType != CALLBACK_TYPE_ALL_MATCHES but no (or only empty) filters are specified. Falling back to callbackType emulation.", new Object[0]);
            resultTransformer = this.scanSettingsEmulator.emulateCallbackType(scanSettings.getCallbackType());
            resultScanSettings = scanSettings.copyWithCallbackType(1);
        }
        return new ScanSetup(new ScanOperationApi21(this.rxBleAdapterWrapper, this.internalScanResultCreator, this.androidScanObjectsConverter, resultScanSettings, new EmulatedScanFilterMatcher(new ScanFilterInterface[0]), scanFilters), (ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>)resultTransformer);
    }

    private static boolean areFiltersSpecified(ScanFilter[] scanFilters) {
        boolean scanFiltersEmpty = true;
        for (ScanFilter scanFilter : scanFilters) {
            scanFiltersEmpty &= scanFilter.isAllFieldsEmpty();
        }
        return !scanFiltersEmpty;
    }
}

