/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.os.DeadObjectException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.QueueOperation;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import io.reactivex.ObservableEmitter;
import io.reactivex.functions.Cancellable;

public abstract class ScanOperation<SCAN_RESULT_TYPE, SCAN_CALLBACK_TYPE>
extends QueueOperation<SCAN_RESULT_TYPE> {
    final RxBleAdapterWrapper rxBleAdapterWrapper;

    ScanOperation(RxBleAdapterWrapper rxBleAdapterWrapper) {
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void protectedRun(ObservableEmitter<SCAN_RESULT_TYPE> emitter, QueueReleaseInterface queueReleaseInterface) {
        final SCAN_CALLBACK_TYPE scanCallback = this.createScanCallback(emitter);
        try {
            emitter.setCancellable(new Cancellable(){

                public void cancel() {
                    RxBleLog.i("Scan operation is requested to stop.", new Object[0]);
                    ScanOperation.this.stopScan(ScanOperation.this.rxBleAdapterWrapper, scanCallback);
                }
            });
            RxBleLog.i("Scan operation is requested to start.", new Object[0]);
            boolean startLeScanStatus = this.startScan(this.rxBleAdapterWrapper, scanCallback);
            if (!startLeScanStatus) {
                emitter.tryOnError((Throwable)new BleScanException(0));
            }
        }
        catch (Throwable throwable) {
            RxBleLog.w(throwable, "Error while calling the start scan function", new Object[0]);
            emitter.tryOnError((Throwable)new BleScanException(0, throwable));
        }
        finally {
            queueReleaseInterface.release();
        }
    }

    @Override
    protected BleException provideException(DeadObjectException deadObjectException) {
        return new BleScanException(1, (Throwable)deadObjectException);
    }

    abstract SCAN_CALLBACK_TYPE createScanCallback(ObservableEmitter<SCAN_RESULT_TYPE> var1);

    abstract boolean startScan(RxBleAdapterWrapper var1, SCAN_CALLBACK_TYPE var2);

    abstract void stopScan(RxBleAdapterWrapper var1, SCAN_CALLBACK_TYPE var2);
}

