/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.ScanOperation;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResultLegacy;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.internal.util.ScanRecordParser;
import io.reactivex.ObservableEmitter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class LegacyScanOperation
extends ScanOperation<RxBleInternalScanResultLegacy, BluetoothAdapter.LeScanCallback> {
    @Nullable
    final Set<UUID> filterUuids;
    final ScanRecordParser scanRecordParser;

    public LegacyScanOperation(UUID[] filterServiceUUIDs, RxBleAdapterWrapper rxBleAdapterWrapper, ScanRecordParser scanRecordParser) {
        super(rxBleAdapterWrapper);
        this.scanRecordParser = scanRecordParser;
        if (filterServiceUUIDs != null && filterServiceUUIDs.length > 0) {
            this.filterUuids = new HashSet<UUID>(filterServiceUUIDs.length);
            Collections.addAll(this.filterUuids, filterServiceUUIDs);
        } else {
            this.filterUuids = null;
        }
    }

    @Override
    BluetoothAdapter.LeScanCallback createScanCallback(final ObservableEmitter<RxBleInternalScanResultLegacy> emitter) {
        return new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                if (LegacyScanOperation.this.filterUuids != null && RxBleLog.isAtLeast(3)) {
                    RxBleLog.d("%s, name=%s, rssi=%d, data=%s", LoggerUtil.commonMacMessage(device.getAddress()), device.getName(), rssi, LoggerUtil.bytesToHex(scanRecord));
                }
                if (LegacyScanOperation.this.filterUuids == null || LegacyScanOperation.this.scanRecordParser.extractUUIDs(scanRecord).containsAll(LegacyScanOperation.this.filterUuids)) {
                    emitter.onNext((Object)new RxBleInternalScanResultLegacy(device, rssi, scanRecord));
                }
            }
        };
    }

    @Override
    boolean startScan(RxBleAdapterWrapper rxBleAdapterWrapper, BluetoothAdapter.LeScanCallback scanCallback) {
        if (this.filterUuids == null) {
            RxBleLog.d("No library side filtering \u2014> debug logs of scanned devices disabled", new Object[0]);
        }
        return rxBleAdapterWrapper.startLegacyLeScan(scanCallback);
    }

    @Override
    void stopScan(RxBleAdapterWrapper rxBleAdapterWrapper, BluetoothAdapter.LeScanCallback scanCallback) {
        rxBleAdapterWrapper.stopLegacyLeScan(scanCallback);
    }

    @NonNull
    public String toString() {
        return "LegacyScanOperation{" + (this.filterUuids == null ? "" : "ALL_MUST_MATCH -> uuids=" + LoggerUtil.getUuidSetToLog(this.filterUuids)) + '}';
    }
}

