/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal;

import android.util.Log;
import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.LogOptions;
import com.polidea.rxandroidble2.internal.logger.LoggerSetup;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.logger.LoggerUtilBluetoothServices;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RxBleLog {
    @Deprecated
    public static final int VERBOSE = 2;
    @Deprecated
    public static final int DEBUG = 3;
    @Deprecated
    public static final int INFO = 4;
    @Deprecated
    public static final int WARN = 5;
    @Deprecated
    public static final int ERROR = 6;
    @Deprecated
    public static final int NONE = Integer.MAX_VALUE;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("\\$\\d+$");
    private static final ThreadLocal<String> NEXT_TAG = new ThreadLocal();
    private static final LogOptions.Logger LOGCAT_LOGGER = new LogOptions.Logger(){

        @Override
        public void log(int level, String tag, String msg) {
            Log.println((int)level, (String)tag, (String)msg);
        }
    };
    private static LoggerSetup loggerSetup = new LoggerSetup(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true, LOGCAT_LOGGER);

    private RxBleLog() {
    }

    @Deprecated
    public static void setLogger(final @Nullable Logger logger) {
        LogOptions.Logger loggerToSet = logger == null ? LOGCAT_LOGGER : new LogOptions.Logger(){

            @Override
            public void log(int level, String tag, String msg) {
                logger.log(level, tag, msg);
            }
        };
        LogOptions newLogOptions = new LogOptions.Builder().setLogger(loggerToSet).build();
        RxBleLog.updateLogOptions(newLogOptions);
    }

    @Deprecated
    public static void setLogLevel(int logLevel) {
        LogOptions newLogOptions = new LogOptions.Builder().setLogLevel(logLevel).build();
        RxBleLog.updateLogOptions(newLogOptions);
    }

    public static void updateLogOptions(LogOptions logOptions) {
        LoggerSetup oldLoggerSetup = loggerSetup;
        LoggerSetup newLoggerSetup = oldLoggerSetup.merge(logOptions);
        RxBleLog.d("Received new options (%s) and merged with old setup: %s. New setup: %s", logOptions, oldLoggerSetup, newLoggerSetup);
        loggerSetup = newLoggerSetup;
    }

    private static String createTag() {
        int i;
        String tag = NEXT_TAG.get();
        if (tag != null) {
            NEXT_TAG.remove();
            return tag;
        }
        List<String> ignoreClasses = Arrays.asList(RxBleLog.class.getName(), LoggerUtil.class.getName(), LoggerUtilBluetoothServices.class.getName());
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        for (i = 0; i < stackTrace.length && ignoreClasses.contains(stackTrace[i].getClassName()); ++i) {
        }
        if (stackTrace.length <= i) {
            throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?", throwable);
        }
        tag = stackTrace[i].getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        tag = tag.replace("Impl", "");
        int endIndex = (tag = tag.replace("RxBle", "")).indexOf(36);
        String classTag = endIndex <= 0 ? tag.substring(tag.lastIndexOf(46) + 1) : tag.substring(tag.lastIndexOf(46) + 1, endIndex);
        return "RxBle#" + classTag;
    }

    private static String formatString(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    public static void v(String message, Object ... args) {
        RxBleLog.throwShade(2, null, message, args);
    }

    public static void v(Throwable t, String message, Object ... args) {
        RxBleLog.throwShade(2, t, message, args);
    }

    public static void d(String message, Object ... args) {
        RxBleLog.throwShade(3, null, message, args);
    }

    public static void d(Throwable t, String message, Object ... args) {
        RxBleLog.throwShade(3, t, message, args);
    }

    public static void i(String message, Object ... args) {
        RxBleLog.throwShade(4, null, message, args);
    }

    public static void i(Throwable t, String message, Object ... args) {
        RxBleLog.throwShade(4, t, message, args);
    }

    public static void w(String message, Object ... args) {
        RxBleLog.throwShade(5, null, message, args);
    }

    public static void w(Throwable t, String message, Object ... args) {
        RxBleLog.throwShade(5, t, message, args);
    }

    public static void e(String message, Object ... args) {
        RxBleLog.throwShade(6, null, message, args);
    }

    public static void e(Throwable t, String message, Object ... args) {
        RxBleLog.throwShade(6, t, message, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void throwShade(int priority, Throwable t, String message, Object ... args) {
        String finalMessage;
        if (priority < RxBleLog.loggerSetup.logLevel) {
            return;
        }
        String formattedMessage = RxBleLog.formatString(message, args);
        if (formattedMessage == null || formattedMessage.length() == 0) {
            if (t == null) return;
            finalMessage = Log.getStackTraceString((Throwable)t);
        } else {
            finalMessage = t != null ? formattedMessage + "\n" + Log.getStackTraceString((Throwable)t) : formattedMessage;
        }
        String tag = RxBleLog.createTag();
        RxBleLog.println(priority, tag, finalMessage);
    }

    private static void println(int priority, String tag, String message) {
        if (message.length() < 4000) {
            RxBleLog.loggerSetup.logger.log(priority, tag, message);
        } else {
            String[] lines;
            for (String line : lines = message.split("\n")) {
                RxBleLog.loggerSetup.logger.log(priority, tag, line);
            }
        }
    }

    public static boolean isAtLeast(int expectedLogLevel) {
        return RxBleLog.loggerSetup.logLevel <= expectedLogLevel;
    }

    public static int getMacAddressLogSetting() {
        return RxBleLog.loggerSetup.macAddressLogSetting;
    }

    public static int getUuidLogSetting() {
        return RxBleLog.loggerSetup.uuidLogSetting;
    }

    public static boolean getShouldLogAttributeValues() {
        return RxBleLog.loggerSetup.shouldLogAttributeValues;
    }

    public static boolean getShouldLogScannedPeripherals() {
        return RxBleLog.loggerSetup.shouldLogScannedPeripherals;
    }

    public static interface Logger {
        public void log(int var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

