/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Provider;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.internal.DeviceComponent;
import com.polidea.rxandroidble2.internal.cache.DeviceComponentCache;
import java.util.Map;

@ClientScope
public class RxBleDeviceProvider {
    private final Map<String, DeviceComponent> cachedDeviceComponents;
    private final Provider<DeviceComponent.Builder> deviceComponentBuilder;

    @Inject
    public RxBleDeviceProvider(DeviceComponentCache deviceComponentCache, Provider<DeviceComponent.Builder> deviceComponentBuilder) {
        this.cachedDeviceComponents = deviceComponentCache;
        this.deviceComponentBuilder = deviceComponentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RxBleDevice getBleDevice(String macAddress) {
        DeviceComponent cachedDeviceComponent = this.cachedDeviceComponents.get(macAddress);
        if (cachedDeviceComponent != null) {
            return cachedDeviceComponent.provideDevice();
        }
        Map<String, DeviceComponent> map = this.cachedDeviceComponents;
        synchronized (map) {
            DeviceComponent secondCheckRxBleDevice = this.cachedDeviceComponents.get(macAddress);
            if (secondCheckRxBleDevice != null) {
                return secondCheckRxBleDevice.provideDevice();
            }
            DeviceComponent deviceComponent = ((DeviceComponent.Builder)this.deviceComponentBuilder.get()).macAddress(macAddress).build();
            RxBleDevice newRxBleDevice = deviceComponent.provideDevice();
            this.cachedDeviceComponents.put(macAddress, deviceComponent);
            return newRxBleDevice;
        }
    }
}

