/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal;

import android.bluetooth.BluetoothDevice;
import androidx.annotation.Nullable;
import bleshadow.javax.inject.Inject;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.polidea.rxandroidble2.ConnectionSetup;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.Timeout;
import com.polidea.rxandroidble2.exceptions.BleAlreadyConnectedException;
import com.polidea.rxandroidble2.internal.DeviceScope;
import com.polidea.rxandroidble2.internal.connection.Connector;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.util.CheckerConnectPermission;
import io.reactivex.Observable;
import java.util.concurrent.atomic.AtomicBoolean;

@DeviceScope
class RxBleDeviceImpl
implements RxBleDevice {
    final BluetoothDevice bluetoothDevice;
    final Connector connector;
    private final BehaviorRelay<RxBleConnection.RxBleConnectionState> connectionStateRelay;
    private final CheckerConnectPermission checkerConnectPermission;
    final AtomicBoolean isConnected = new AtomicBoolean(false);

    @Inject
    RxBleDeviceImpl(BluetoothDevice bluetoothDevice, Connector connector, BehaviorRelay<RxBleConnection.RxBleConnectionState> connectionStateRelay, CheckerConnectPermission checkerConnectPermission) {
        this.bluetoothDevice = bluetoothDevice;
        this.connector = connector;
        this.connectionStateRelay = connectionStateRelay;
        this.checkerConnectPermission = checkerConnectPermission;
    }

    @Override
    public Observable<RxBleConnection.RxBleConnectionState> observeConnectionStateChanges() {
        return this.connectionStateRelay.distinctUntilChanged().skip(1L);
    }

    @Override
    public RxBleConnection.RxBleConnectionState getConnectionState() {
        return (RxBleConnection.RxBleConnectionState)((Object)this.connectionStateRelay.getValue());
    }

    @Override
    public Observable<RxBleConnection> establishConnection(boolean autoConnect) {
        ConnectionSetup options = new ConnectionSetup.Builder().setAutoConnect(autoConnect).setSuppressIllegalOperationCheck(true).build();
        return this.establishConnection(options);
    }

    @Override
    public Observable<RxBleConnection> establishConnection(boolean autoConnect, Timeout timeout) {
        ConnectionSetup options = new ConnectionSetup.Builder().setAutoConnect(autoConnect).setOperationTimeout(timeout).setSuppressIllegalOperationCheck(true).build();
        return this.establishConnection(options);
    }

    public Observable<RxBleConnection> establishConnection(ConnectionSetup options) {
        return Observable.defer(() -> {
            if (this.isConnected.compareAndSet(false, true)) {
                return this.connector.prepareConnection(options).doFinally(() -> this.isConnected.set(false));
            }
            return Observable.error((Throwable)new BleAlreadyConnectedException(this.bluetoothDevice.getAddress()));
        });
    }

    @Override
    @Nullable
    public String getName() {
        return this.getName(false);
    }

    private String getName(boolean placeholderIfNoPermission) {
        if (placeholderIfNoPermission && !this.checkerConnectPermission.isConnectRuntimePermissionGranted()) {
            return "[NO BLUETOOTH_CONNECT PERMISSION]";
        }
        return this.bluetoothDevice.getName();
    }

    @Override
    public String getMacAddress() {
        return this.bluetoothDevice.getAddress();
    }

    @Override
    public BluetoothDevice getBluetoothDevice() {
        return this.bluetoothDevice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RxBleDeviceImpl)) {
            return false;
        }
        RxBleDeviceImpl that = (RxBleDeviceImpl)o;
        return this.bluetoothDevice.equals((Object)that.bluetoothDevice);
    }

    public int hashCode() {
        return this.bluetoothDevice.hashCode();
    }

    public String toString() {
        return "RxBleDeviceImpl{" + LoggerUtil.commonMacMessage(this.bluetoothDevice.getAddress()) + ", name=" + this.getName(true) + '}';
    }
}

