/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.exceptions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.polidea.rxandroidble2.exceptions.BleAdapterDisabledException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.utils.GattStatusParser;

public class BleDisconnectedException
extends BleException {
    public static final int UNKNOWN_STATUS = -1;
    @NonNull
    public final String bluetoothDeviceAddress;
    public final int state;

    public static BleDisconnectedException adapterDisabled(String macAddress) {
        return new BleDisconnectedException(new BleAdapterDisabledException(), macAddress, -1);
    }

    @Deprecated
    public BleDisconnectedException() {
        this("", -1);
    }

    @Deprecated
    public BleDisconnectedException(Throwable throwable, @NonNull String bluetoothDeviceAddress) {
        this(throwable, bluetoothDeviceAddress, -1);
    }

    @Deprecated
    public BleDisconnectedException(@NonNull String bluetoothDeviceAddress) {
        this(bluetoothDeviceAddress, -1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BleDisconnectedException(Throwable throwable, @NonNull String bluetoothDeviceAddress, int status) {
        super(BleDisconnectedException.createMessage(bluetoothDeviceAddress, status), throwable);
        this.bluetoothDeviceAddress = bluetoothDeviceAddress;
        this.state = status;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BleDisconnectedException(@NonNull String bluetoothDeviceAddress, int status) {
        super(BleDisconnectedException.createMessage(bluetoothDeviceAddress, status));
        this.bluetoothDeviceAddress = bluetoothDeviceAddress;
        this.state = status;
    }

    private static String createMessage(@Nullable String bluetoothDeviceAddress, int status) {
        String gattCallbackStatusDescription = GattStatusParser.getGattCallbackStatusDescription(status);
        return "Disconnected from " + LoggerUtil.commonMacMessage(bluetoothDeviceAddress) + " with status " + status + " (" + gattCallbackStatusDescription + ")";
    }
}

