/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.multipartycall;

import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.base.BaseResponse;
import com.plivo.api.models.multipartycall.MultiPartyCallGet;
import com.plivo.api.models.multipartycall.MultiPartyCallList;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipant;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantAdd;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantGet;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantKick;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantList;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingPause;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingResume;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingStart;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingStop;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantUpdate;
import com.plivo.api.models.multipartycall.MultiPartyCallRecordingPause;
import com.plivo.api.models.multipartycall.MultiPartyCallRecordingResume;
import com.plivo.api.models.multipartycall.MultiPartyCallRecordingStart;
import com.plivo.api.models.multipartycall.MultiPartyCallRecordingStop;
import com.plivo.api.models.multipartycall.MultiPartyCallStart;
import com.plivo.api.models.multipartycall.MultiPartyCallStartPlayAudio;
import com.plivo.api.models.multipartycall.MultiPartyCallStop;
import com.plivo.api.models.multipartycall.MultiPartyCallStopPlayAudio;
import com.plivo.api.models.multipartycall.MultiPartyCallUtils;
import java.io.IOException;
import java.util.List;

public class MultiPartyCall
extends BaseResource {
    private String billedAmount;
    private Long billedDuration;
    private String creationTime;
    private Long duration;
    private String endTime;
    private String friendlyName;
    private String mpcUuid;
    private String participants;
    private String recording;
    private String resourceUri;
    private String startTime;
    private String status;
    private String stayAlone;
    private String subAccount;
    private String terminationCause;
    private Long terminationCauseCode;

    public static MultiPartyCallList lister() {
        return new MultiPartyCallList();
    }

    public static MultiPartyCallGet getter(String mpcId) {
        return new MultiPartyCallGet(mpcId);
    }

    public MultiPartyCall get() throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallGet getter = MultiPartyCall.getter(this.getId());
        return (MultiPartyCall)getter.get();
    }

    public static MultiPartyCallStart starter(String mpcId) {
        return new MultiPartyCallStart(mpcId);
    }

    public BaseResponse start() throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallStart start = MultiPartyCall.starter(this.getId());
        return start.update();
    }

    public static MultiPartyCallStop stopper(String mpcId) {
        return new MultiPartyCallStop(mpcId);
    }

    public void stop() throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallStop stop = MultiPartyCall.stopper(this.getId());
        stop.delete();
    }

    public static MultiPartyCallParticipantAdd addParticipant(String mpcId, String role, String from, List<String> to) throws PlivoValidationException {
        return new MultiPartyCallParticipantAdd(mpcId, role, from, to);
    }

    public static MultiPartyCallParticipantAdd addParticipant(String mpcId, String role, String callUuid) {
        return new MultiPartyCallParticipantAdd(mpcId, role, callUuid);
    }

    public MultiPartyCallParticipantAdd addParticipant(String role, String from, List<String> to) throws PlivoValidationException {
        return new MultiPartyCallParticipantAdd(this.getId(), role, from, to);
    }

    public MultiPartyCallParticipantAdd addParticipant(String role, String callUuid) throws PlivoValidationException {
        return new MultiPartyCallParticipantAdd(this.getId(), role, callUuid);
    }

    public static MultiPartyCallParticipantList participantList(String mpcId) {
        return new MultiPartyCallParticipantList(mpcId);
    }

    public MultiPartyCallParticipantList participantList() throws PlivoValidationException {
        return new MultiPartyCallParticipantList(this.getId());
    }

    public static MultiPartyCallRecordingStart recordStarter(String mpcId) {
        return new MultiPartyCallRecordingStart(mpcId);
    }

    public MultiPartyCallRecordingStart recordStarter() throws PlivoValidationException {
        return new MultiPartyCallRecordingStart(this.getId());
    }

    public static MultiPartyCallRecordingStop recordStopper(String mpcId) {
        return new MultiPartyCallRecordingStop(mpcId);
    }

    public void recordStop() throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallRecordingStop recordStopper = new MultiPartyCallRecordingStop(this.getId());
        recordStopper.delete();
    }

    public static MultiPartyCallRecordingPause recordPause(String mpcId) {
        return new MultiPartyCallRecordingPause(mpcId);
    }

    public BaseResponse recordPause() throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallRecordingPause(this.getId()).update();
    }

    public static MultiPartyCallRecordingResume recordResume(String mpcId) {
        return new MultiPartyCallRecordingResume(mpcId);
    }

    public BaseResponse recordResume() throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallRecordingResume(this.getId()).update();
    }

    public static MultiPartyCallParticipantRecordingStart participantRecordStarter(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingStart(mpcId, participantId);
    }

    public MultiPartyCallParticipantRecordingStart participantRecordStarter(String participantId) throws PlivoValidationException {
        return new MultiPartyCallParticipantRecordingStart(this.getId(), participantId);
    }

    public static MultiPartyCallParticipantRecordingStop participantRecordStopper(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingStop(mpcId, participantId);
    }

    public void participantRecordStop(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallParticipantRecordingStop participantRecordStopper = new MultiPartyCallParticipantRecordingStop(this.getId(), participantId);
        participantRecordStopper.delete();
    }

    public static MultiPartyCallParticipantRecordingPause participantRecordPause(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingPause(mpcId, participantId);
    }

    public BaseResponse participantRecordPause(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallParticipantRecordingPause(this.getId(), participantId).update();
    }

    public static MultiPartyCallParticipantRecordingResume participantRecordResume(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingResume(mpcId, participantId);
    }

    public BaseResponse participantRecordResume(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallParticipantRecordingPause(this.getId(), participantId).update();
    }

    public static MultiPartyCallParticipantGet participantGetter(String mpcId, String participantId) {
        return new MultiPartyCallParticipantGet(mpcId, participantId);
    }

    public MultiPartyCallParticipant participantGet(String participantId) throws PlivoRestException, IOException, PlivoValidationException {
        MultiPartyCallParticipantGet getter = new MultiPartyCallParticipantGet(this.getId(), participantId);
        return (MultiPartyCallParticipant)getter.get();
    }

    public static MultiPartyCallParticipantUpdate participantUpdater(String mpcId, String participantId) {
        return new MultiPartyCallParticipantUpdate(mpcId, participantId);
    }

    public MultiPartyCallParticipantUpdate participantUpdate(String participantId) throws PlivoValidationException {
        return new MultiPartyCallParticipantUpdate(this.getId(), participantId);
    }

    public static MultiPartyCallParticipantKick participantKicker(String mpcId, String participantId) {
        return new MultiPartyCallParticipantKick(mpcId, participantId);
    }

    public void participantKick(String participantId) throws PlivoRestException, IOException, PlivoValidationException {
        MultiPartyCallParticipantKick kicker = new MultiPartyCallParticipantKick(this.getId(), participantId);
        kicker.delete();
    }

    public static MultiPartyCallStartPlayAudio startPlayAudio(String mpcId, String participantId) {
        return new MultiPartyCallStartPlayAudio(mpcId, participantId);
    }

    public static MultiPartyCallStopPlayAudio stopPlayAudio(String mpcId, String participantId) {
        return new MultiPartyCallStopPlayAudio(mpcId, participantId);
    }

    public String getBilledAmount() {
        return this.billedAmount;
    }

    public Long getBilledDuration() {
        return this.billedDuration;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getMpcUuid() {
        return this.mpcUuid;
    }

    public String getParticipants() {
        return this.participants;
    }

    public String getRecording() {
        return this.recording;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStayAlone() {
        return this.stayAlone;
    }

    public String getSubAccount() {
        return this.subAccount;
    }

    public String getTerminationCause() {
        return this.terminationCause;
    }

    public Long getTerminationCauseCode() {
        return this.terminationCauseCode;
    }

    @Override
    public String getId() throws PlivoValidationException {
        return MultiPartyCallUtils.mpcUuid(this.getMpcUuid());
    }
}

