/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.postgresql;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.postgresql.PostgreSQLProperties;
import com.playtika.testcontainer.toxiproxy.ToxiproxyClientProxy;
import com.playtika.testcontainer.toxiproxy.ToxiproxyHelper;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.postgresql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PostgreSQLProperties.class})
public class EmbeddedPostgreSQLBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPostgreSQLBootstrapConfiguration.class);
    private static final String POSTGRESQL_NETWORK_ALIAS = "postgresql.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="postgresql")
    ToxiproxyClientProxy postgresqlContainerProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedPostgreSql") PostgreSQLContainer postgresql, ConfigurableEnvironment environment) {
        ToxiproxyClientProxy proxy = ToxiproxyHelper.createProxy((ToxiproxyClient)toxiproxyClient, (ToxiproxyContainer)toxiproxyContainer, (GenericContainer)postgresql, (int)PostgreSQLContainer.POSTGRESQL_PORT, (String)"postgresql");
        ToxiproxyHelper.registerProxyEnvironment((ToxiproxyClientProxy)proxy, (String)"embedded.postgresql", (String)"embeddedPostgresqlToxiproxyInfo", (ConfigurableEnvironment)environment);
        return proxy;
    }

    @Bean(name={"embeddedPostgreSql"}, destroyMethod="stop")
    public PostgreSQLContainer postgresql(ConfigurableEnvironment environment, PostgreSQLProperties properties, Optional<Network> network) {
        PostgreSQLContainer postgresql = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withUsername(properties.getUser()).withPassword(properties.getPassword()).withDatabaseName(properties.getDatabase()).withInitScript(properties.initScriptPath)).withNetworkAliases(new String[]{POSTGRESQL_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((PostgreSQLContainer)postgresql).withNetwork(arg_0));
        String startupLogCheckRegex = properties.getStartupLogCheckRegex();
        if (StringUtils.hasLength((String)startupLogCheckRegex)) {
            LogMessageWaitStrategy waitStrategy = new LogMessageWaitStrategy().withRegEx(startupLogCheckRegex);
            postgresql.waitingFor((WaitStrategy)waitStrategy);
        }
        postgresql = (PostgreSQLContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)postgresql, (CommonContainerProperties)properties, (Logger)log);
        this.registerPostgresqlEnvironment(postgresql, environment, properties);
        return postgresql;
    }

    private void registerPostgresqlEnvironment(PostgreSQLContainer postgresql, ConfigurableEnvironment environment, PostgreSQLProperties properties) {
        Integer mappedPort = postgresql.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
        String host = postgresql.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.postgresql.port", mappedPort);
        map.put("embedded.postgresql.host", host);
        map.put("embedded.postgresql.schema", properties.getDatabase());
        map.put("embedded.postgresql.user", properties.getUser());
        map.put("embedded.postgresql.password", properties.getPassword());
        map.put("embedded.postgresql.networkAlias", POSTGRESQL_NETWORK_ALIAS);
        map.put("embedded.postgresql.internalPort", PostgreSQLContainer.POSTGRESQL_PORT);
        String jdbcURL = "jdbc:postgresql://{}:{}/{}";
        log.info("Started postgresql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedPostgreInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

