/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.java11;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.java11.HttpClientFeignCustomizer;
import reactivefeign.java11.Java11ReactiveOptions;
import reactivefeign.java11.client.Java11ReactiveHttpClientFactory;

public final class Java11ReactiveFeign {
    private Java11ReactiveFeign() {
    }

    public static <T> Builder<T> builder() {
        try {
            return Java11ReactiveFeign.builder(HttpClient.newBuilder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Builder<T> builder(HttpClient.Builder httpClientBuilder) {
        return new Builder(httpClientBuilder, new JsonFactory());
    }

    public static <T> Builder<T> builder(HttpClientFeignCustomizer clientFeignCustomizer) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        clientFeignCustomizer.accept(httpClientBuilder);
        return new Builder(httpClientBuilder, new JsonFactory());
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected HttpClient.Builder httpClientBuilder;
        protected JsonFactory jsonFactory;
        private ObjectMapper objectMapper;
        protected Java11ReactiveOptions options;

        protected Builder(HttpClient.Builder httpClientBuilder, JsonFactory jsonFactory) {
            this.httpClientBuilder = httpClientBuilder;
            this.jsonFactory = jsonFactory;
            this.objectMapper = new ObjectMapper().findAndRegisterModules();
            this.updateClientFactory();
        }

        public ReactiveFeignBuilder<T> objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.updateClientFactory();
            return this;
        }

        public Builder<T> options(ReactiveOptions options) {
            ReactiveOptions.ProxySettings proxySettings;
            this.options = (Java11ReactiveOptions)options;
            if (this.options.getConnectTimeoutMillis() != null) {
                this.httpClientBuilder = this.httpClientBuilder.connectTimeout(Duration.ofMillis(options.getConnectTimeoutMillis()));
            }
            if (options.isFollowRedirects() != null) {
                this.httpClientBuilder = this.httpClientBuilder.followRedirects(options.isFollowRedirects() != false ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
            }
            if ((proxySettings = options.getProxySettings()) != null) {
                this.httpClientBuilder = this.httpClientBuilder.proxy(ProxySelector.of(new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort())));
            }
            this.updateClientFactory();
            return this;
        }

        protected void updateClientFactory() {
            this.httpClientBuilder = this.httpClientBuilder.version(ReactiveOptions.useHttp2((ReactiveOptions)this.options) ? HttpClient.Version.HTTP_2 : HttpClient.Version.HTTP_1_1);
            HttpClient httpClient = this.httpClientBuilder.build();
            this.clientFactory(new Java11ReactiveHttpClientFactory(httpClient, this.jsonFactory, this.objectMapper, this.options));
        }
    }
}

