/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.java11.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import feign.MethodMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.java11.client.Java11ReactiveHttpResponse;
import reactivefeign.utils.FeignUtils;
import reactivefeign.utils.HttpUtils;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Java11ReactiveHttpClient
implements ReactiveHttpClient {
    private final HttpClient httpClient;
    private final Class bodyActualClass;
    private final Class returnPublisherClass;
    private final Class returnActualClass;
    private final JsonFactory jsonFactory;
    private final ObjectWriter bodyWriter;
    private final ObjectReader responseReader;
    private long requestTimeout = -1L;
    private boolean tryUseCompression = false;

    public static Java11ReactiveHttpClient jettyClient(MethodMetadata methodMetadata, HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        Class returnPublisherType = FeignUtils.returnPublisherType((MethodMetadata)methodMetadata);
        Type returnActualType = FeignUtils.returnActualType((MethodMetadata)methodMetadata);
        Type bodyActualType = FeignUtils.getBodyActualType((Type)methodMetadata.bodyType());
        ObjectWriter bodyWriter = bodyActualType != null ? objectMapper.writerFor(objectMapper.constructType(bodyActualType)) : null;
        ObjectReader responseReader = objectMapper.readerFor(objectMapper.constructType(returnActualType));
        return new Java11ReactiveHttpClient(httpClient, Java11ReactiveHttpClient.getClass(bodyActualType), returnPublisherType, Java11ReactiveHttpClient.getClass(returnActualType), jsonFactory, bodyWriter, responseReader);
    }

    public Java11ReactiveHttpClient(HttpClient httpClient, Class bodyActualClass, Class returnPublisherClass, Class returnActualClass, JsonFactory jsonFactory, ObjectWriter bodyWriter, ObjectReader responseReader) {
        this.httpClient = httpClient;
        this.bodyActualClass = bodyActualClass;
        this.returnPublisherClass = returnPublisherClass;
        this.returnActualClass = returnActualClass;
        this.jsonFactory = jsonFactory;
        this.bodyWriter = bodyWriter;
        this.responseReader = responseReader;
    }

    public Java11ReactiveHttpClient setRequestTimeout(long timeoutInMillis) {
        this.requestTimeout = timeoutInMillis;
        return this;
    }

    public Java11ReactiveHttpClient setTryUseCompression(boolean tryUseCompression) {
        this.tryUseCompression = tryUseCompression;
        return this;
    }

    public Mono<ReactiveHttpResponse> executeRequest(ReactiveHttpRequest request) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(request.uri()).method(request.method().toUpperCase(), this.provideBody(request));
        this.setUpHeaders(request, requestBuilder);
        if (this.requestTimeout > 0L) {
            requestBuilder = requestBuilder.timeout(Duration.ofMillis(this.requestTimeout));
        }
        if (this.tryUseCompression) {
            requestBuilder = requestBuilder.setHeader("Accept-Encoding", "gzip");
        }
        Java11ReactiveHttpResponse.ReactiveBodySubscriber bodySubscriber = new Java11ReactiveHttpResponse.ReactiveBodySubscriber();
        CompletableFuture<HttpResponse<Void>> response = this.httpClient.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.fromSubscriber(bodySubscriber));
        return Mono.fromFuture(response).map(resp -> {
            if (!resp.version().equals((Object)this.httpClient.version())) {
                throw new IllegalArgumentException("Incorrect response version:" + resp.version());
            }
            return new Java11ReactiveHttpResponse(request, (HttpResponse)resp, (Publisher<List<ByteBuffer>>)bodySubscriber.content(), this.returnPublisherClass, this.returnActualClass, this.jsonFactory, this.responseReader);
        }).onErrorMap(ex -> {
            if (ex instanceof HttpTimeoutException) {
                return new ReadTimeoutException(ex.getCause(), request);
            }
            return new ReactiveFeignException(ex, request);
        });
    }

    protected void setUpHeaders(ReactiveHttpRequest request, HttpRequest.Builder requestBuilder) {
        request.headers().forEach((key, values) -> values.forEach(value -> requestBuilder.header((String)key, (String)value)));
        String contentTypeHeader = this.getContentTypeHeader(request);
        if (contentTypeHeader != null) {
            requestBuilder.header("Content-Type", contentTypeHeader);
        }
        requestBuilder.header("Accept", this.getAcceptHeader());
    }

    private String getAcceptHeader() {
        String acceptHeader = CharSequence.class.isAssignableFrom(this.returnActualClass) && this.returnPublisherClass == Mono.class ? "text/plain" : (this.returnActualClass == ByteBuffer.class || this.returnActualClass == byte[].class ? "application/octet-stream" : (this.returnPublisherClass == Mono.class ? "application/json" : "application/stream+json"));
        return acceptHeader;
    }

    private String getContentTypeHeader(ReactiveHttpRequest request) {
        if (this.bodyActualClass == null) {
            return null;
        }
        String contentType = request.body() instanceof Mono ? (this.bodyActualClass == ByteBuffer.class ? "application/octet-stream" : (CharSequence.class.isAssignableFrom(this.bodyActualClass) ? "text/plain;charset=utf-8" : "application/json;charset=utf-8")) : (this.bodyActualClass == ByteBuffer.class ? "application/octet-stream" : "application/stream+json;charset=utf-8");
        return contentType;
    }

    protected HttpRequest.BodyPublisher provideBody(ReactiveHttpRequest request) {
        if (this.bodyActualClass == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Object bodyPublisher = request.body() instanceof Mono ? (this.bodyActualClass == ByteBuffer.class ? (Mono)request.body() : (CharSequence.class.isAssignableFrom(this.bodyActualClass) ? Flux.from((Publisher)request.body()).map(this::toCharSequenceChunk) : Flux.from((Publisher)request.body()).map(data -> this.toJsonChunk(data, false)))) : (this.bodyActualClass == ByteBuffer.class ? request.body() : Flux.from((Publisher)request.body()).map(data -> this.toJsonChunk(data, true)));
        return HttpRequest.BodyPublishers.fromPublisher(JdkFlowAdapter.publisherToFlowPublisher((Publisher)bodyPublisher));
    }

    protected ByteBuffer toCharSequenceChunk(Object data) {
        CharBuffer charBuffer = CharBuffer.wrap((CharSequence)data);
        return StandardCharsets.UTF_8.encode(charBuffer);
    }

    protected ByteBuffer toJsonChunk(Object data, boolean stream) {
        try {
            ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
            this.bodyWriter.writeValue((OutputStream)byteArrayBuilder, data);
            if (stream) {
                byteArrayBuilder.write(HttpUtils.NEWLINE_SEPARATOR);
            }
            return ByteBuffer.wrap(byteArrayBuilder.toByteArray());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Class getClass(Type type) {
        return (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
    }
}

