/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;

@FunctionalInterface
public interface ThrowingIntFunction<R, E extends Exception> {
    public R apply(int var1) throws E;

    default public IntFunction<R> uncheck() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }

    public static <R> IntFunction<R> unchecked(ThrowingIntFunction<R, ?> f) {
        return Objects.requireNonNull(f).uncheck();
    }

    public static <R> IntFunction<Optional<R>> lifted(ThrowingIntFunction<R, ?> f) {
        return Objects.requireNonNull(f).lift();
    }

    public static <R> IntFunction<R> sneaky(ThrowingIntFunction<? extends R, ?> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    default public IntFunction<Optional<R>> lift() {
        return t -> {
            try {
                return Optional.ofNullable(this.apply(t));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }
}

