/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.license.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Properties;
import org.smartboot.license.client.LicenseEntity;
import org.smartboot.license.client.Md5;
import org.smartboot.license.server.LicenseEncode;

public class LicenseRevert {
    public static void main(String[] args) throws IOException, ParseException {
        if (args.length == 0) {
            System.err.println("file path is null");
            return;
        }
        File file = new File(args[0]);
        if (file.isFile()) {
            LicenseRevert.createLicense(new FileInputStream(file));
        } else {
            System.err.println("file " + file.getAbsolutePath() + " is not exists");
        }
    }

    private static void createLicense(InputStream inputStream) throws IOException, ParseException {
        Properties properties = new Properties();
        properties.load(inputStream);
        String expireTime = properties.getProperty("expireDate");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] content = decoder.decode(properties.getProperty("base64Content"));
        byte[] publicKey = decoder.decode(properties.getProperty("publicKey"));
        byte[] privateKey = decoder.decode(properties.getProperty("privateKey"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LicenseEntity licenseEntity = new LicenseEntity(sdf.parse(expireTime).getTime(), publicKey, Md5.md5((byte[])content));
        licenseEntity.setData(content);
        File file = new File("license_revert.txt");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            LicenseEncode licenseEncode = new LicenseEncode();
            fileOutputStream.write(Base64.getEncoder().encodeToString(licenseEncode.encode(licenseEntity, privateKey)).getBytes(StandardCharsets.UTF_8));
        }
    }
}

