/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.license.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.smartboot.license.client.LicenseEntity;
import org.smartboot.license.server.RasUtil;

class LicenseEncode {
    private static final int MAX_DATA_LENGTH = 64;
    private static final int MIN_DATA_LENGTH = 32;

    LicenseEncode() {
    }

    public byte[] encode(LicenseEntity entity, byte[] privateKey) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(LicenseEntity.MAGIC_NUM);
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        outputStream.writeObject(entity);
        outputStream.write(entity.getSplitFlag());
        outputStream.writeLong(entity.getApplyTime());
        outputStream.writeLong(entity.getExpireTime());
        outputStream.write(entity.getSplitFlag());
        outputStream.write(entity.getPublicKeys().length);
        outputStream.write(entity.getPublicKeys());
        outputStream.write(entity.getSplitFlag());
        int offset = 0;
        int step = this.nextStep();
        byte[] data = entity.getData();
        if (data.length < step) {
            step = data.length;
        }
        while (offset < data.length) {
            byte[] encryptData = RasUtil.encryptByPrivateKey(data, privateKey, offset, step);
            outputStream.write(encryptData.length);
            outputStream.write(encryptData);
            outputStream.write(entity.getSplitFlag());
            outputStream.writeLong(entity.getExpireTime() % (long)step);
            outputStream.flush();
            int nextStep = this.nextStep();
            step = Math.min(data.length - (offset += step), nextStep);
        }
        outputStream.write(0);
        outputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private int nextStep() {
        int step = (int)(System.nanoTime() % 64L);
        if (step < 32) {
            step = 32;
        }
        return step;
    }
}

