/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.mock.provider.serial;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialBase;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.util.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSerial
extends SerialBase
implements Serial {
    private static final Logger logger = LoggerFactory.getLogger(MockSerial.class);
    protected ArrayDeque<Byte> raw = new ArrayDeque();

    public MockSerial(SerialProvider provider, SerialConfig config) {
        super(provider, config);
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: OPEN(DEVICE=" + config.device() + "; BAUD=" + config.baud() + ")");
        logger.info("");
    }

    public int available() {
        return this.raw.size();
    }

    public void close() {
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: CLOSE(DEVICE=" + ((SerialConfig)this.config).device() + "; BAUD=" + ((SerialConfig)this.config).baud() + ")");
        logger.info("");
        super.close();
    }

    public int write(byte b) {
        this.raw.add(b);
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return 0;
    }

    public int write(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int p = offset;
        while (p - offset < length) {
            this.raw.add(data[p]);
            ++p;
        }
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(0x");
        logger.info(StringUtil.toHexString((byte[])data, (int)offset, (int)length));
        logger.info(")");
        return length;
    }

    public int write(Charset charset, CharSequence data) {
        byte[] buffer = data.toString().getBytes(charset);
        for (int p = 0; p < buffer.length; ++p) {
            this.raw.add(buffer[p]);
        }
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(\"");
        logger.info(data.toString());
        logger.info("\")");
        return data.length();
    }

    public int read() {
        if (this.raw.isEmpty()) {
            return -1;
        }
        byte b = this.raw.pop();
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ (0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return b;
    }

    public int read(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (this.raw.isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.raw.isEmpty(); ++p) {
            buffer[offset + p] = this.raw.pop();
            ++counter;
        }
        logger.info(" [");
        logger.info("Mock Serial Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ (0x");
        logger.info(StringUtil.toHexString((byte[])buffer, (int)offset, (int)length));
        logger.info(")");
        return counter;
    }
}

