/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.mock.provider.i2c;

import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CBase;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.i2c.I2CRegisterDataReader;
import com.pi4j.io.i2c.I2CRegisterDataWriter;
import com.pi4j.util.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockI2C
extends I2CBase
implements I2C,
I2CRegisterDataReader,
I2CRegisterDataWriter {
    private static final Logger logger = LoggerFactory.getLogger(MockI2C.class);
    protected ArrayDeque<Byte>[] registers = new ArrayDeque[512];
    protected ArrayDeque<Byte> raw = new ArrayDeque();

    public MockI2C(I2CProvider provider, I2CConfig config) {
        super(provider, config);
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: CREATE(BUS=" + config.bus() + "; DEVICE=" + config.device() + ")");
        logger.info("");
    }

    public void close() {
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: CLOSE(BUS=" + ((I2CConfig)this.config).bus() + "; DEVICE=" + ((I2CConfig)this.config).device() + ")");
        logger.info("");
        super.close();
    }

    public int write(byte b) {
        this.raw.add(b);
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return 0;
    }

    public int write(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int p = offset;
        while (p - offset < length) {
            this.raw.add(data[p]);
            ++p;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(0x");
        logger.info(StringUtil.toHexString((byte[])data, (int)offset, (int)length));
        logger.info(")");
        return length;
    }

    public int write(Charset charset, CharSequence data) {
        byte[] buffer = data.toString().getBytes(charset);
        for (int p = 0; p < buffer.length; ++p) {
            this.raw.add(buffer[p]);
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(\"");
        logger.info(data.toString());
        logger.info("\")");
        return data.length();
    }

    public int read() {
        if (this.raw.isEmpty()) {
            return -1;
        }
        byte b = this.raw.pop();
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ(0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return b & 0xFF;
    }

    public int read(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (this.raw.isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.raw.isEmpty(); ++p) {
            buffer[offset + p] = this.raw.pop();
            ++counter;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ(0x");
        logger.info(StringUtil.toHexString((byte[])buffer, (int)offset, (int)length));
        logger.info(")");
        return counter;
    }

    public String readString(Charset charset, int length) {
        if (this.raw.isEmpty()) {
            return null;
        }
        byte[] buffer = new byte[length];
        for (int p = 0; p < length && !this.raw.isEmpty(); ++p) {
            buffer[p] = this.raw.pop();
        }
        String result = new String(buffer, charset);
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ(\"");
        logger.info(result);
        logger.info("\")");
        return result;
    }

    public int writeRegister(int register, byte b) {
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        this.registers[register].add(b);
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(");
        logger.info("REG=");
        logger.info(String.valueOf(register));
        logger.info(", 0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return 0;
    }

    public int writeRegister(int register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        int p = offset;
        while (p - offset < length) {
            this.registers[register].add(data[p]);
            ++p;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITEREGISTER(");
        logger.info("Chip register offset Decimal : " + register + "  Hex : " + String.format("%02X", register));
        logger.info("offset = " + String.format("%02X", offset));
        logger.info(",User data:     0x   " + StringUtil.toHexString((byte[])data, (int)offset, (int)length));
        logger.info(")");
        return length;
    }

    public int writeRegister(byte[] register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int internalOffset = (register[0] & 0xFF) + (register[1] << 8);
        if (this.registers[internalOffset] == null) {
            this.registers[internalOffset] = new ArrayDeque();
        }
        int p = offset;
        while (p - offset < length) {
            this.registers[internalOffset].add(data[p]);
            ++p;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITEREGISTER(");
        logger.info("REG= (two byte offset LSB first)");
        logger.info(StringUtil.toHexString((byte[])register, (int)0, (int)register.length));
        logger.info("Chip register offset Decimal : " + internalOffset + "  Hex : " + String.format("%02X", internalOffset));
        logger.info("offset = " + String.format("%02X", offset));
        logger.info(",User data:     0x   " + StringUtil.toHexString((byte[])data, (int)offset, (int)length));
        logger.info(")");
        return length;
    }

    public int writeRegister(int register, Charset charset, CharSequence data) {
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        byte[] buffer = data.toString().getBytes(charset);
        for (int p = 0; p < buffer.length; ++p) {
            this.registers[register].add(buffer[p]);
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: WRITE(");
        logger.info("REG=");
        logger.info(String.valueOf(register));
        logger.info(", \"");
        logger.info(String.valueOf(data));
        logger.info("\")");
        return data.length();
    }

    public int readRegister(int register) {
        if (this.registers[register] == null) {
            throw new IllegalStateException("No available data to read");
        }
        if (this.registers[register].isEmpty()) {
            throw new IllegalStateException("No available data to read");
        }
        byte b = this.registers[register].pop();
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ(");
        logger.info("REG=");
        logger.info(String.valueOf(register));
        logger.info(", 0x");
        logger.info(StringUtil.toHexString((byte)b));
        logger.info(")");
        return b;
    }

    public int readRegister(byte[] register, byte[] buffer, int offset, int length) {
        int internalOffset = (register[0] & 0xFF) + (register[1] << 8);
        if (this.registers[internalOffset] == null) {
            return -1;
        }
        if (this.registers[internalOffset].isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.registers[internalOffset].isEmpty(); ++p) {
            buffer[offset + p] = this.registers[internalOffset].pop();
            ++counter;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READREGISTER(");
        logger.info("REG= (two byte offset LSB first)");
        logger.info(StringUtil.toHexString((byte[])register, (int)0, (int)register.length));
        logger.info("offset = " + String.format("%02X", offset));
        logger.info("Chip register offset Decimal : " + internalOffset + "  Hex : " + String.format("%02X", internalOffset));
        logger.info(", 0x");
        logger.info(StringUtil.toHexString((byte[])buffer, (int)offset, (int)length));
        logger.info(")");
        return counter;
    }

    public int readRegister(int register, byte[] buffer, int offset, int length) {
        if (this.registers[register] == null) {
            return -1;
        }
        if (this.registers[register].isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.registers[register].isEmpty(); ++p) {
            buffer[offset + p] = this.registers[register].pop();
            ++counter;
        }
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READREGISTER(");
        logger.info("offset = " + String.format("%02X", offset));
        logger.info("Chip register offset Decimal : " + register + "  Hex : " + String.format("%02X", register));
        logger.info(String.valueOf(register));
        logger.info(", 0x");
        logger.info(StringUtil.toHexString((byte[])buffer, (int)offset, (int)length));
        logger.info(")");
        return counter;
    }

    public String readRegisterString(int register, Charset charset, int length) {
        if (this.registers[register] == null) {
            return null;
        }
        if (this.registers[register].isEmpty()) {
            return null;
        }
        byte[] buffer = new byte[length];
        for (int p = 0; p < length && !this.registers[register].isEmpty(); ++p) {
            buffer[p] = this.registers[register].pop();
        }
        String result = new String(buffer, charset);
        logger.info(" [");
        logger.info("Mock I2C Provider");
        logger.info("::");
        logger.info(this.id);
        logger.info("] :: READ(");
        logger.info("REG=");
        logger.info(String.valueOf(register));
        logger.info(", \"");
        logger.info(result);
        logger.info("\")");
        return result;
    }
}

