/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeGenerator
extends Generator<ZonedDateTime> {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private ZonedDateTime min = ZonedDateTime.of(-999999999, 1, 1, 0, 0, 0, 0, UTC_ZONE_ID);
    private ZonedDateTime max = ZonedDateTime.of(999999999, 12, 31, 23, 59, 59, 999999999, UTC_ZONE_ID);

    public ZonedDateTimeGenerator() {
        super(ZonedDateTime.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = ZonedDateTime.parse(range.min(), formatter).withZoneSameInstant(UTC_ZONE_ID);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = ZonedDateTime.parse(range.max(), formatter).withZoneSameInstant(UTC_ZONE_ID);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", range.min(), range.max()));
        }
    }

    public ZonedDateTime generate(SourceOfRandomness random, GenerationStatus status) {
        return ZonedDateTime.ofInstant(random.nextInstant(this.min.toInstant(), this.max.toInstant()), UTC_ZONE_ID);
    }
}

