/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class OffsetDateTimeGenerator
extends Generator<OffsetDateTime> {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private OffsetDateTime min = OffsetDateTime.MIN;
    private OffsetDateTime max = OffsetDateTime.MAX;

    public OffsetDateTimeGenerator() {
        super(OffsetDateTime.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = OffsetDateTime.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = OffsetDateTime.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", range.min(), range.max()));
        }
    }

    public OffsetDateTime generate(SourceOfRandomness random, GenerationStatus status) {
        return OffsetDateTime.ofInstant(random.nextInstant(this.min.toInstant(), this.max.toInstant()), UTC_ZONE_ID);
    }
}

