/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.DescriptorIndexNode;
import com.pff.LZFu;
import com.pff.PSTAttachment;
import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import com.pff.PSTRecipient;
import com.pff.PSTTable7C;
import com.pff.PSTTable7CItem;
import com.pff.PSTTableBC;
import com.pff.PSTTableBCItem;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSTMessage
extends PSTObject {
    public static final int IMPORTANCE_LOW = 0;
    public static final int IMPORTANCE_NORMAL = 1;
    public static final int IMPORTANCE_HIGH = 2;
    public static final int RECIPIENT_TYPE_TO = 1;
    public static final int RECIPIENT_TYPE_CC = 2;
    private PSTTable7C recipientTable = null;
    private PSTTable7C attachmentTable = null;

    PSTMessage(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    PSTMessage(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        super(theFile, folderIndexNode, table, localDescriptorItems);
    }

    public String getRTFBody() throws PSTException, IOException {
        if (this.items.containsKey(4105)) {
            PSTTableBCItem item = (PSTTableBCItem)this.items.get(4105);
            if (item.data.length > 0) {
                return LZFu.decode(item.data);
            }
            int ref = item.entryValueReference;
            PSTDescriptorItem descItem = (PSTDescriptorItem)this.localDescriptorItems.get(ref);
            if (descItem != null) {
                return LZFu.decode(descItem.getData());
            }
        }
        return "";
    }

    public int getImportance() {
        return this.getIntItem(23, 1);
    }

    @Override
    public String getMessageClass() {
        return this.getStringItem(26);
    }

    public String getSubject() {
        String subject = this.getStringItem(55);
        if (subject != null && subject.length() >= 2 && subject.charAt(0) == '\u0001') {
            subject = subject.length() == 2 ? "" : subject.substring(2, subject.length());
        }
        return subject;
    }

    public Date getClientSubmitTime() {
        return this.getDateItem(57);
    }

    public String getReceivedByName() {
        return this.getStringItem(64);
    }

    public String getSentRepresentingName() {
        return this.getStringItem(66);
    }

    public String getSentRepresentingAddressType() {
        return this.getStringItem(100);
    }

    public String getSentRepresentingEmailAddress() {
        return this.getStringItem(101);
    }

    public String getConversationTopic() {
        return this.getStringItem(112);
    }

    public String getReceivedByAddressType() {
        return this.getStringItem(117);
    }

    public String getReceivedByAddress() {
        return this.getStringItem(118);
    }

    public String getTransportMessageHeaders() {
        return this.getStringItem(125);
    }

    public boolean isRead() {
        return (this.getIntItem(3591) & 1) != 0;
    }

    public boolean isUnmodified() {
        return (this.getIntItem(3591) & 2) != 0;
    }

    public boolean isSubmitted() {
        return (this.getIntItem(3591) & 4) != 0;
    }

    public boolean isUnsent() {
        return (this.getIntItem(3591) & 8) != 0;
    }

    public boolean hasAttachments() {
        return (this.getIntItem(3591) & 0x10) != 0;
    }

    public boolean isFromMe() {
        return (this.getIntItem(3591) & 0x20) != 0;
    }

    public boolean isAssociated() {
        return (this.getIntItem(3591) & 0x40) != 0;
    }

    public boolean isResent() {
        return (this.getIntItem(3591) & 0x80) != 0;
    }

    public int getAcknowledgementMode() {
        return this.getIntItem(1);
    }

    public boolean getOriginatorDeliveryReportRequested() {
        return this.getIntItem(35) != 0;
    }

    public int getPriority() {
        return this.getIntItem(38);
    }

    public boolean getReadReceiptRequested() {
        return this.getIntItem(41) != 0;
    }

    public boolean getRecipientReassignmentProhibited() {
        return this.getIntItem(43) != 0;
    }

    public int getOriginalSensitivity() {
        return this.getIntItem(46);
    }

    public int getSensitivity() {
        return this.getIntItem(54);
    }

    public byte[] getPidTagSentRepresentingSearchKey() {
        return this.getBinaryItem(59);
    }

    public String getRcvdRepresentingName() {
        return this.getStringItem(68);
    }

    public String getOriginalSubject() {
        return this.getStringItem(73);
    }

    public String getReplyRecipientNames() {
        return this.getStringItem(80);
    }

    public boolean getMessageToMe() {
        return this.getIntItem(87) != 0;
    }

    public boolean getMessageCcMe() {
        return this.getIntItem(88) != 0;
    }

    public String getMessageRecipMe() {
        return this.getStringItem(89);
    }

    public boolean getResponseRequested() {
        return this.getBooleanItem(99);
    }

    public String getSentRepresentingAddrtype() {
        return this.getStringItem(100);
    }

    public String getOriginalDisplayBcc() {
        return this.getStringItem(114);
    }

    public String getOriginalDisplayCc() {
        return this.getStringItem(115);
    }

    public String getOriginalDisplayTo() {
        return this.getStringItem(116);
    }

    public String getRcvdRepresentingAddrtype() {
        return this.getStringItem(119);
    }

    public String getRcvdRepresentingEmailAddress() {
        return this.getStringItem(120);
    }

    public boolean isNonReceiptNotificationRequested() {
        return this.getIntItem(3078) != 0;
    }

    public boolean isOriginatorNonDeliveryReportRequested() {
        return this.getIntItem(3080) != 0;
    }

    public int getRecipientType() {
        return this.getIntItem(3093);
    }

    public boolean isReplyRequested() {
        return this.getIntItem(3095) != 0;
    }

    public byte[] getSenderEntryId() {
        return this.getBinaryItem(3097);
    }

    public String getSenderName() {
        return this.getStringItem(3098);
    }

    public String getSenderAddrtype() {
        return this.getStringItem(3102);
    }

    public String getSenderEmailAddress() {
        return this.getStringItem(3103);
    }

    public long getMessageSize() {
        return this.getLongItem(3592);
    }

    public int getInternetArticleNumber() {
        return this.getIntItem(3619);
    }

    public String getPrimarySendAccount() {
        return this.getStringItem(3624);
    }

    public String getNextSendAcct() {
        return this.getStringItem(3625);
    }

    public int getURLCompNamePostfix() {
        return this.getIntItem(3681);
    }

    public int getObjectType() {
        return this.getIntItem(4094);
    }

    public boolean getDeleteAfterSubmit() {
        return this.getIntItem(3585) != 0;
    }

    public boolean getResponsibility() {
        return this.getIntItem(3599) != 0;
    }

    public boolean isRTFInSync() {
        return this.getIntItem(3615) != 0;
    }

    public boolean isURLCompNameSet() {
        return this.getIntItem(3682) != 0;
    }

    public String getDisplayBCC() {
        return this.getStringItem(3586);
    }

    public String getDisplayCC() {
        return this.getStringItem(3587);
    }

    public String getDisplayTo() {
        return this.getStringItem(3588);
    }

    public Date getMessageDeliveryTime() {
        return this.getDateItem(3590);
    }

    public String getBody() {
        String cp = null;
        PSTTableBCItem cpItem = (PSTTableBCItem)this.items.get(16381);
        if (cpItem == null) {
            cpItem = (PSTTableBCItem)this.items.get(16350);
        }
        if (cpItem != null) {
            cp = PSTFile.getInternetCodePageCharset(cpItem.entryValueReference);
        }
        return this.getStringItem(4096, 0, cp);
    }

    public String getBodyPrefix() {
        return this.getStringItem(26137);
    }

    public int getRTFSyncBodyCRC() {
        return this.getIntItem(4102);
    }

    public int getRTFSyncBodyCount() {
        return this.getIntItem(4103);
    }

    public String getRTFSyncBodyTag() {
        return this.getStringItem(4104);
    }

    public int getRTFSyncPrefixCount() {
        return this.getIntItem(4112);
    }

    public int getRTFSyncTrailingCount() {
        return this.getIntItem(4113);
    }

    public String getBodyHTML() {
        String cp = null;
        PSTTableBCItem cpItem = (PSTTableBCItem)this.items.get(16350);
        if (cpItem == null) {
            cpItem = (PSTTableBCItem)this.items.get(16381);
        }
        if (cpItem != null) {
            cp = PSTFile.getInternetCodePageCharset(cpItem.entryValueReference);
        }
        return this.getStringItem(4115, 0, cp);
    }

    public String getInternetMessageId() {
        return this.getStringItem(4149);
    }

    public String getInReplyToId() {
        return this.getStringItem(4162);
    }

    public String getReturnPath() {
        return this.getStringItem(4166);
    }

    public int getIconIndex() {
        return this.getIntItem(4224);
    }

    public int getActionFlag() {
        return this.getIntItem(4225);
    }

    public boolean hasForwarded() {
        int actionFlag = this.getIntItem(4225);
        return (actionFlag & 8) > 0;
    }

    public boolean hasReplied() {
        int actionFlag = this.getIntItem(4225);
        return (actionFlag & 4) > 0;
    }

    public Date getActionDate() {
        return this.getDateItem(4226);
    }

    public boolean getDisableFullFidelity() {
        return this.getIntItem(4338) != 0;
    }

    public String getURLCompName() {
        return this.getStringItem(4339);
    }

    public boolean getAttrHidden() {
        return this.getIntItem(4340) != 0;
    }

    public boolean getAttrSystem() {
        return this.getIntItem(4341) != 0;
    }

    public boolean getAttrReadonly() {
        return this.getIntItem(4342) != 0;
    }

    private void processRecipients() {
        try {
            int recipientTableKey = 1682;
            if (this.recipientTable == null && this.localDescriptorItems != null && this.localDescriptorItems.containsKey(recipientTableKey)) {
                PSTDescriptorItem item = (PSTDescriptorItem)this.localDescriptorItems.get(recipientTableKey);
                HashMap<Integer, PSTDescriptorItem> descriptorItems = null;
                if (item.subNodeOffsetIndexIdentifier > 0) {
                    descriptorItems = this.pstFile.getPSTDescriptorItems(item.subNodeOffsetIndexIdentifier);
                }
                this.recipientTable = new PSTTable7C(new PSTNodeInputStream(this.pstFile, item), descriptorItems);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recipientTable = null;
        }
    }

    public int getNumberOfRecipients() throws PSTException, IOException {
        this.processRecipients();
        if (this.recipientTable == null) {
            return 0;
        }
        return this.recipientTable.getRowCount();
    }

    private void processAttachments() throws PSTException, IOException {
        int attachmentTableKey = 1649;
        if (this.attachmentTable == null && this.localDescriptorItems != null && this.localDescriptorItems.containsKey(attachmentTableKey)) {
            PSTDescriptorItem item = (PSTDescriptorItem)this.localDescriptorItems.get(attachmentTableKey);
            HashMap<Integer, PSTDescriptorItem> descriptorItems = null;
            if (item.subNodeOffsetIndexIdentifier > 0) {
                descriptorItems = this.pstFile.getPSTDescriptorItems(item.subNodeOffsetIndexIdentifier);
            }
            this.attachmentTable = new PSTTable7C(new PSTNodeInputStream(this.pstFile, item), descriptorItems);
        }
    }

    public Date getTaskStartDate() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33028, 10));
    }

    public Date getTaskDueDate() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33029, 10));
    }

    public boolean getReminderSet() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(34051, 1));
    }

    public int getReminderDelta() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(34049, 1));
    }

    public boolean isFlagged() {
        return this.getTaskDueDate() != null;
    }

    public String[] getColorCategories() throws PSTException {
        String[] categories = new String[]{};
        if (this.items.containsKey(32790)) {
            try {
                PSTTableBCItem item = (PSTTableBCItem)this.items.get(32790);
                int categoryCount = item.data[0];
                if (categoryCount > 0) {
                    String name;
                    int x;
                    categories = new String[categoryCount];
                    int[] offsets = new int[categoryCount];
                    for (x = 0; x < categoryCount; ++x) {
                        offsets[x] = (int)PSTObject.convertBigEndianBytesToLong(item.data, x * 4 + 1, (x + 1) * 4 + 1);
                    }
                    for (x = 0; x < offsets.length - 1; ++x) {
                        String name2;
                        int start = offsets[x];
                        int end = offsets[x + 1];
                        int length = end - start;
                        byte[] string = new byte[length];
                        System.arraycopy(item.data, start, string, 0, length);
                        categories[x] = name2 = new String(string, "UTF-16LE");
                    }
                    int start = offsets[offsets.length - 1];
                    int end = item.data.length;
                    int length = end - start;
                    byte[] string = new byte[length];
                    System.arraycopy(item.data, start, string, 0, length);
                    categories[categories.length - 1] = name = new String(string, "UTF-16LE");
                }
            }
            catch (Exception err) {
                throw new PSTException("Unable to decode category data", err);
            }
        }
        return categories;
    }

    public int getNumberOfAttachments() {
        try {
            this.processAttachments();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        if (this.attachmentTable == null) {
            return 0;
        }
        return this.attachmentTable.getRowCount();
    }

    public PSTAttachment getAttachment(int attachmentNumber) throws PSTException, IOException {
        this.processAttachments();
        int attachmentCount = 0;
        if (this.attachmentTable != null) {
            attachmentCount = this.attachmentTable.getRowCount();
        }
        if (attachmentNumber >= attachmentCount) {
            throw new PSTException("unable to fetch attachment number " + attachmentNumber + ", only " + attachmentCount + " in this email");
        }
        HashMap<Integer, PSTTable7CItem> attachmentDetails = this.attachmentTable.getItems().get(attachmentNumber);
        PSTTable7CItem attachmentTableItem = attachmentDetails.get(26610);
        int descriptorItemId = attachmentTableItem.entryValueReference;
        PSTDescriptorItem descriptorItem = (PSTDescriptorItem)this.localDescriptorItems.get(descriptorItemId);
        byte[] attachmentData = descriptorItem.getData();
        if (attachmentData != null && attachmentData.length > 0) {
            PSTTableBC attachmentDetailsTable = new PSTTableBC(new PSTNodeInputStream(this.pstFile, descriptorItem));
            HashMap<Integer, PSTDescriptorItem> attachmentDescriptorItems = new HashMap<Integer, PSTDescriptorItem>();
            if (descriptorItem.subNodeOffsetIndexIdentifier > 0) {
                attachmentDescriptorItems = this.pstFile.getPSTDescriptorItems(descriptorItem.subNodeOffsetIndexIdentifier);
            }
            return new PSTAttachment(this.pstFile, attachmentDetailsTable, attachmentDescriptorItems);
        }
        throw new PSTException("unable to fetch attachment number " + attachmentNumber + ", unable to read attachment details table");
    }

    public PSTRecipient getRecipient(int recipientNumber) throws PSTException, IOException {
        if (recipientNumber >= this.getNumberOfRecipients()) {
            throw new PSTException("unable to fetch recipient number " + recipientNumber);
        }
        HashMap<Integer, PSTTable7CItem> recipientDetails = this.recipientTable.getItems().get(recipientNumber);
        if (recipientDetails != null) {
            return new PSTRecipient(recipientDetails);
        }
        return null;
    }

    public String getRecipientsString() {
        if (this.recipientTable != null) {
            return this.recipientTable.getItemsString();
        }
        return "No recipients table!";
    }

    @Override
    public String toString() {
        return "PSTEmail: " + this.getSubject() + "\n" + "Importance: " + this.getImportance() + "\n" + "Message Class: " + this.getMessageClass() + "\n\n" + this.getTransportMessageHeaders() + "\n\n\n" + this.items + this.localDescriptorItems;
    }
}

