/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.jaxb.MultiXSDSchemaLoosener;
import com.peterphi.std.util.jaxb.type.MultiXSDSchemaFile;
import com.peterphi.std.util.jaxb.type.MultiXSDSchemaFiles;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiXSDSchemaCollector
extends SchemaOutputResolver {
    private final Map<String, DOMResult> schemas = new HashMap<String, DOMResult>();
    private boolean loosenXmlAnyConstraints = true;

    public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
        DOMResult result = new DOMResult();
        result.setSystemId(suggestedFileName);
        this.schemas.put(suggestedFileName, result);
        return result;
    }

    public MultiXSDSchemaCollector withLoosenXmlAnyConstraints(boolean value) {
        this.loosenXmlAnyConstraints = value;
        return this;
    }

    public MultiXSDSchemaFiles encode() {
        MultiXSDSchemaFiles files = new MultiXSDSchemaFiles();
        for (Map.Entry<String, DOMResult> entry : this.schemas.entrySet()) {
            MultiXSDSchemaFile file = new MultiXSDSchemaFile();
            file.name = entry.getKey();
            file.schema = this.getElement(entry.getValue().getNode());
            files.files.add(file);
        }
        if (this.loosenXmlAnyConstraints) {
            MultiXSDSchemaLoosener.loosenXmlAnyOtherNamespaceToXmlAnyAnyNamespace(files);
        }
        return files;
    }

    private Element getElement(Node node) {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new IllegalArgumentException("Cannot extract Element from node: " + node);
    }
}

