/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public final class Logging {
    public static boolean WATCH = true;
    private static File currentLogFile = null;

    private Logging() {
    }

    public static void configureFiles(Iterable<File> files) {
        for (File file : files) {
            if (file == null || !file.exists() || !file.canRead()) continue;
            Logging.setup(file);
            return;
        }
        System.out.println("(No suitable log config file found)");
    }

    private static synchronized void setup(File logFile) {
        if (currentLogFile != null && currentLogFile != logFile) {
            Logger log = Logger.getLogger(Logging.class);
            log.warn((Object)("[Logging] {setup} Logging is being reconfigured to use: " + logFile.getAbsolutePath()));
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configureAndWatch((String)logFile.getAbsolutePath());
        currentLogFile = logFile;
    }

    public static void configure(File ... files) {
        if (files == null || files.length == 0 || files.length == 1 && files[0] == null) {
            return;
        }
        Logging.configureFiles(Arrays.asList(files));
    }

    public static void configure(String ... fileNames) {
        if (fileNames == null || fileNames.length == 0 || fileNames.length == 1 && fileNames[0] == null) {
            return;
        }
        Logging.configureNames(Arrays.asList(fileNames));
    }

    public static void configureNames(Iterable<String> fileNames) {
        if (fileNames == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : fileNames) {
            if (fileName == null) continue;
            files.add(new File(fileName));
        }
        Logging.configureFiles(files);
    }
}

