/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PEMHelper {
    private PEMHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadCertificates(File pemFile) {
        try (PemReader pem = new PemReader((Reader)new FileReader(pemFile));){
            Object obj;
            KeyStore ks = PEMHelper.createEmptyKeyStore();
            int certIndex = 0;
            while ((obj = PEMHelper.parse(pem.readPemObject())) != null) {
                if (!(obj instanceof Certificate)) throw new RuntimeException("Unknown PEM contents: " + obj + ". Expected a Certificate");
                Certificate cert = (Certificate)obj;
                ks.setCertificateEntry("cert" + Integer.toString(certIndex++), cert);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing PEM " + pemFile, e);
        }
    }

    public static Object parse(PemObject obj) throws GeneralSecurityException {
        if (obj == null) {
            return null;
        }
        if (obj.getType() == null) {
            throw new RuntimeException("Encountered invalid PemObject with null type: " + obj);
        }
        if (obj.getType().equalsIgnoreCase("CERTIFICATE") || obj.getType().equalsIgnoreCase("X.509 CERTIFICATE")) {
            return PEMHelper.parseX509Certificate(obj);
        }
        throw new IllegalArgumentException("Unknown PEM contents: encountered unsupported entry of type " + obj.getType() + " (expected CERTIFICATE or X.509 CERTIFICATE)");
    }

    private static Certificate parseX509Certificate(PemObject obj) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificate(new ByteArrayInputStream(obj.getContent()));
    }

    private static KeyStore createEmptyKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        return ks;
    }
}

