/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.xstream.serialisers;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class MapStringStringConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public void marshal(Object valueO, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map val = (Map)valueO;
        for (Map.Entry entry : val.entrySet()) {
            writer.startNode((String)entry.getKey());
            writer.setValue((String)entry.getValue());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getNodeName();
            String value = reader.getValue();
            map.put(key, value);
            reader.moveUp();
        }
        return map;
    }
}

