/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.jaxb.JAXBSerialiser;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class JAXBSerialiserFactory {
    private final ConcurrentHashMap<String, SoftReference<JAXBSerialiser>> cache = new ConcurrentHashMap();
    private final boolean useMoxy;

    public JAXBSerialiserFactory(boolean useMoxy) {
        this.useMoxy = useMoxy;
    }

    protected JAXBSerialiser getInstance(String key, Supplier<JAXBSerialiser> provider) {
        JAXBSerialiser instance;
        SoftReference<JAXBSerialiser> ref = this.cache.get(key);
        JAXBSerialiser jAXBSerialiser = instance = ref != null ? ref.get() : null;
        if (instance == null) {
            instance = provider.get();
            this.cache.put(key, new SoftReference<JAXBSerialiser>(instance));
            this.prune();
        }
        return instance;
    }

    private void prune() {
        Iterator<Map.Entry<String, SoftReference<JAXBSerialiser>>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SoftReference<JAXBSerialiser>> entry = it.next();
            if (entry.getValue() != null && entry.getValue().get() != null) continue;
            it.remove();
        }
    }

    public JAXBSerialiser getInstance(Class<?> clazz) {
        return this.getInstance(clazz.toString(), () -> this.construct(clazz));
    }

    public JAXBSerialiser getInstance(String contextPath) {
        return this.getInstance(contextPath, () -> this.construct(contextPath));
    }

    JAXBSerialiser construct(String contextPath) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(contextPath);
        }
        return JAXBSerialiser.getInstance(contextPath);
    }

    JAXBSerialiser construct(Class<?> clazz) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(clazz);
        }
        return JAXBSerialiser.getInstance(clazz);
    }
}

