/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util;

import com.peterphi.std.threading.Timeout;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Ticker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long started;

    public Ticker() {
        this(System.currentTimeMillis());
    }

    public Ticker(Date date) {
        this(date.getTime());
    }

    public Ticker(Calendar calendar) {
        this(calendar.getTimeInMillis());
    }

    public Ticker(long started) {
        this.started = started;
    }

    public final String toString() {
        long elapsed = this.getElapsed();
        if (elapsed < 1000L) {
            if (elapsed != 1L) {
                return elapsed + " milliseconds";
            }
            return "1 millisecond";
        }
        long seconds = elapsed / 1000L;
        long millis = elapsed % 1000L;
        return seconds + "." + millis + " seconds";
    }

    public Date getStartDate() {
        return new Date(this.started);
    }

    public long getStart() {
        return this.started;
    }

    public long getElapsed() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.started;
        return elapsed;
    }

    public Timeout getElapsedTime() {
        return new Timeout(this.getElapsed(), TimeUnit.MILLISECONDS);
    }
}

