/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Version MIN_VALUE = new Version(0);
    public static final Version MAX_VALUE = new Version("max");
    private int[] version;

    public Version(String versionString) {
        if (versionString != null && versionString.length() > 0) {
            boolean minmaxSet = false;
            String[] sVersion = versionString.split("\\.");
            if (sVersion.length == 0) {
                throw new NumberFormatException("A Version string must contain at least one digit");
            }
            this.version = new int[sVersion.length];
            for (int i = 0; i < sVersion.length; ++i) {
                if (sVersion[i].toLowerCase().equals("min")) {
                    this.version[i] = 0;
                    minmaxSet = true;
                    continue;
                }
                if (sVersion[i].toLowerCase().equals("max")) {
                    this.version[i] = Integer.MAX_VALUE;
                    minmaxSet = true;
                    continue;
                }
                if (sVersion[i].length() == 0) {
                    throw new NumberFormatException("Each segment of a Version MUST be a number: no empty segments are permitted");
                }
                if (!minmaxSet) {
                    if (!sVersion[i].equals("O")) {
                        this.version[i] = Integer.parseInt(sVersion[i]);
                    } else {
                        System.err.println("***Standard Library Warning*** Version string " + versionString + " contains a capital O (the letter o) segment. Assuming you mean 0 (zero)");
                        new Exception("tracer").printStackTrace();
                        this.version[i] = 0;
                    }
                    if (this.version[i] >= 0) continue;
                    throw new NumberFormatException("A Version may not contain negative segments");
                }
                throw new NumberFormatException("A Version string may only have min or max at the end. It must comply with the following regex: ^((min|max)|([0-9]+(\\.[0-9]+)*(\\.min|\\.max)?))$");
            }
        } else {
            throw new NumberFormatException("A version string must contain at least one digit");
        }
    }

    public Version(int ... vers) {
        if (vers == null || vers.length == 0) {
            throw new NumberFormatException("A version must contain at least one digit");
        }
        for (int v : vers) {
            if (v >= 0) continue;
            throw new NumberFormatException("A Version may not contain negative segments");
        }
        this.version = vers;
    }

    public int getField(int index, int defaultValue) {
        if (index >= 0 && index < this.version.length) {
            return this.version[index];
        }
        return defaultValue;
    }

    public int getField(int index) {
        assert (index >= 0 && index < this.version.length);
        if (index >= 0 && index < this.version.length) {
            return this.version[index];
        }
        throw new IllegalArgumentException("The field index requested does not exist in this Version object");
    }

    public boolean within(Version min, Version max) {
        return this.compareTo(min) >= 0 && this.compareTo(max) <= 0;
    }

    public static boolean overlapping(Version min1, Version max1, Version min2, Version max2) {
        return min1.equals(min2) || max1.equals(max2) || min2.within(min1, max1) || max2.within(min1, min2) || min1.within(min2, max2) || max1.within(min2, max2);
    }

    public String toString() {
        Object[] segments = new String[this.version.length];
        for (int i = 0; i < this.version.length; ++i) {
            segments[i] = this.version[i] != Integer.MAX_VALUE ? Integer.toString(this.version[i]) : "max";
        }
        return StringUtils.join((Object[])segments, (String)".");
    }

    @Override
    public int compareTo(Version vers) {
        int[] v1 = this.version;
        int[] v2 = vers.version;
        int minLength = v1.length < v2.length ? v1.length : v2.length;
        int maxLength = v1.length < v2.length ? v2.length : v1.length;
        boolean v1short = minLength == v1.length;
        boolean same = v2.length == v1.length;
        for (int i = 0; i < maxLength; ++i) {
            int v2v;
            int v1v;
            if (same || i < minLength) {
                v1v = v1[i];
                v2v = v2[i];
            } else if (v1short) {
                v1v = 0;
                v2v = v2[i];
            } else {
                v2v = 0;
                v1v = v1[i];
            }
            if (v1v < v2v) {
                return -1;
            }
            if (v1v <= v2v) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Version) {
            Version v = (Version)o;
            return v.compareTo(this) == 0;
        }
        return false;
    }

    public int hashCode() {
        int total = 0;
        for (int n : this.version) {
            total += n;
        }
        return total;
    }

    @Deprecated
    public int[] getContent() {
        return (int[])this.version.clone();
    }

    @Deprecated
    public void setContent(int[] content) {
        if (content == null || content.length == 0) {
            throw new NumberFormatException("A Version must contain at least one digit");
        }
        this.version = content;
    }

    @Deprecated
    public Version() {
        this.version = null;
    }

    public String toComparableString() {
        Object[] segments = new String[this.version.length];
        for (int i = 0; i < this.version.length; ++i) {
            segments[i] = Version.pad(this.version[i]);
        }
        return StringUtils.join((Object[])segments, (String)".");
    }

    private static String pad(int i) {
        String s = Integer.toString(i, 36);
        int padChars = 6 - s.length();
        switch (padChars) {
            case 0: {
                return s;
            }
            case 1: {
                return "0" + s;
            }
            case 2: {
                return "00" + s;
            }
            case 3: {
                return "000" + s;
            }
            case 4: {
                return "0000" + s;
            }
            case 5: {
                return "0000" + s;
            }
        }
        throw new IllegalArgumentException("Invalid number " + i + " - conversion to base-36 produced a length outside the range 1-6");
    }

    public static Version parseStringComparable(String version) {
        String[] str = version.split("\\.");
        int[] asint = new int[str.length];
        for (int i = 0; i < str.length; ++i) {
            asint[i] = Integer.parseInt(str[i], 36);
        }
        return new Version(asint);
    }
}

