/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public enum StorageUnit {
    BITS(1, "b", "Bit"),
    NIBBLES(4, "Nibble", "Nibble"),
    BYTES(8, "B", "Byte"),
    KILOBYTES(BigInteger.valueOf(1024L), "KiB", "Kilobyte"),
    MEGABYTES(BigInteger.valueOf(0x100000L), "MiB", "Megabyte"),
    GIGABYTES(BigInteger.valueOf(0x40000000L), "GiB", "Gigabyte"),
    TERABYTES(BigInteger.valueOf(0x10000000000L), "TiB", "Terabyte"),
    PETABYTES(BigInteger.valueOf(0x4000000000000L), "PiB", "Petabyte"),
    EXABYTES(BigInteger.valueOf(0x1000000000000000L), "EiB", "Exabyte"),
    ZETTABYTES(new BigInteger("1180591620717411303424"), "ZiB", "Zettabyte"),
    YOTTABYTES(new BigInteger("1208925819614629174706176"), "YiB", "Yottabyte"),
    DECIMAL_KILOBYTES(BigInteger.valueOf(1000L), "KB", "Decimal kilobyte"),
    DECIMAL_MEGABYTES(BigInteger.valueOf(1000000L), "MB", "Decimal megabyte"),
    DECIMAL_GIGABYTES(BigInteger.valueOf(1000000000L), "GB", "Decimal gigabyte"),
    DECIMAL_TERABYTES(BigInteger.valueOf(1000000000000L), "TB", "Decimal terabyte"),
    DECIMAL_PETABYTES(BigInteger.valueOf(1000000000000000L), "PB", "Decimal petabyte"),
    DECIMAL_EXABYTES(BigInteger.valueOf(1000000000000000000L), "EB", "Decimal exabyte"),
    DECIMAL_ZETTABYTES(new BigInteger("1000000000000000000000"), "ZB", "Decimal zettabyte"),
    DECIMAL_YOTTABYTES(new BigInteger("1000000000000000000000000"), "YB", "Decimal yottabyte"),
    KILOBITS(BigInteger.valueOf(125L), "Kb", "Kilobit"),
    MEGABITS(BigInteger.valueOf(125000L), "Mb", "Megabit"),
    GIGABITS(BigInteger.valueOf(125000000L), "Gb", "Gigabit"),
    TERABITS(BigInteger.valueOf(125000000000L), "Tb", "Terabit"),
    PETABITS(BigInteger.valueOf(125000000000000L), "Pb", "Petabit"),
    EXABITS(BigInteger.valueOf(125000000000000000L), "Eb", "Exabit"),
    ZETTABITS(new BigInteger("125000000000000000000"), "Zb", "Zettabit"),
    YOTTABITS(new BigInteger("125000000000000000000000"), "Yb", "Yottabit");

    public static final StorageUnit[] NETWORK_DECIMAL;
    public static final StorageUnit[] STORAGE_DECIMAL;
    public static final StorageUnit[] COMPSCI_BINARY;
    public static final StorageUnit[] DECIMAL_QUANTIFIERS;
    public static final StorageUnit[] BINARY_QUANTIFIERS;
    private static final BigInteger MAX_LONG;
    private static final long UNIT_UPCONVERT_THRESHOLD = 8L;
    private static final BigInteger UNIT_UPCONVERT_THRESHOLD_BIG;
    public static final int ROUNDING_MODE = 4;
    private final BigInteger numBits;
    private final BigDecimal numBitsDecimal;
    private final String isoUnit;
    private final String singular;
    private final String plural;

    private StorageUnit(int numBits, String isoUnit, String stem) {
        this.numBits = BigInteger.valueOf(numBits);
        this.numBitsDecimal = new BigDecimal(numBits);
        this.isoUnit = isoUnit;
        this.singular = stem;
        this.plural = stem + "s";
    }

    private StorageUnit(BigInteger numBytes, String isoUnit, String stem) {
        this.numBits = numBytes.multiply(BigInteger.valueOf(8L));
        this.numBitsDecimal = new BigDecimal(this.numBits);
        this.isoUnit = isoUnit;
        this.singular = stem;
        this.plural = stem + "s";
    }

    public String getISOUnit() {
        return this.isoUnit;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getSingular() {
        return this.singular;
    }

    private static BigDecimal convert(StorageUnit from, StorageUnit to, BigDecimal amount) {
        if (from == to || amount == BigDecimal.ZERO) {
            return amount;
        }
        BigDecimal bits = from.toBits(amount);
        return to.fromBits(bits);
    }

    private static BigInteger convert(StorageUnit from, StorageUnit to, BigInteger amount) {
        if (from == to || amount == BigInteger.ZERO) {
            return amount;
        }
        BigInteger bits = from.toBits(amount);
        return to.fromBits(bits);
    }

    private static long convert(StorageUnit from, StorageUnit to, long amount) {
        if (from == to || amount == 0L) {
            return amount;
        }
        BigInteger bigAmount = BigInteger.valueOf(amount);
        BigInteger result = StorageUnit.convert(from, to, bigAmount);
        if (result.compareTo(MAX_LONG) > 0) {
            throw new ArithmeticException("Conversion failed: result was " + result + " out of the bounds of a long type!");
        }
        return result.longValue();
    }

    public long convert(long amount, StorageUnit unit) {
        return StorageUnit.convert(unit, this, amount);
    }

    public BigInteger convert(BigInteger amount, StorageUnit unit) {
        return StorageUnit.convert(unit, this, amount);
    }

    public BigDecimal convert(BigDecimal amount, StorageUnit unit) {
        return StorageUnit.convert(unit, this, amount);
    }

    public BigInteger toBits(BigInteger amount) {
        if (this == BITS) {
            return amount;
        }
        return amount.multiply(this.numBits);
    }

    public BigDecimal toBits(BigDecimal amount) {
        if (this == BITS) {
            return amount;
        }
        return amount.multiply(this.numBitsDecimal);
    }

    public BigInteger fromBits(BigInteger bits) {
        if (this == BITS) {
            return bits;
        }
        return bits.divide(this.numBits);
    }

    public BigDecimal fromBits(BigDecimal bits) {
        if (this == BITS) {
            return bits;
        }
        return bits.divide(this.numBitsDecimal);
    }

    public long toBytes(long amount) {
        return BYTES.convert(amount, this);
    }

    public BigDecimal toBytes(BigDecimal amount) {
        return BYTES.convert(amount, this);
    }

    public BigInteger toBytes(BigInteger amount) {
        return BYTES.convert(amount, this);
    }

    private String getQuantifier(boolean isPlural, boolean shortType) {
        if (!shortType) {
            if (isPlural) {
                return this.plural;
            }
            return this.singular;
        }
        return this.isoUnit;
    }

    private String getQuantifierFor(long amount, boolean shortType) {
        boolean isPlural = amount != 1L;
        return this.getQuantifier(isPlural, shortType);
    }

    private String getQuantifierFor(BigInteger amount, boolean shortType) {
        boolean isPlural = amount.compareTo(BigInteger.ONE) != 0;
        return this.getQuantifier(isPlural, shortType);
    }

    private String getQuantifierFor(BigDecimal amount, boolean shortType) {
        boolean isPlural = !amount.equals(BigDecimal.ONE);
        return this.getQuantifier(isPlural, shortType);
    }

    public String toString(long amount) {
        return this.toString(amount, false);
    }

    public String toString(BigInteger amount) {
        return this.toString(amount, false);
    }

    public String toString(BigDecimal amount) {
        return this.toString(amount, false);
    }

    public String toString(long amount, boolean shortType) {
        String quantifier = this.getQuantifierFor(amount, shortType);
        return Long.toString(amount) + " " + quantifier;
    }

    public String toString(BigInteger amount, boolean shortType) {
        String quantifier = this.getQuantifierFor(amount, shortType);
        return amount.toString() + " " + quantifier;
    }

    public String toString(BigDecimal amount, boolean shortType) {
        String quantifier = this.getQuantifierFor(amount, shortType);
        BigDecimal rounded = amount.setScale(3, RoundingMode.HALF_UP);
        String plainString = rounded.toPlainString();
        if (plainString.endsWith(".000")) {
            plainString = plainString.substring(0, plainString.length() - 4);
        }
        return plainString + " " + quantifier;
    }

    private boolean isSensibleUnitFor(BigInteger amount, StorageUnit sourceUnit) {
        if (amount.equals(BigInteger.ZERO)) {
            return true;
        }
        BigInteger amountOfThisUnit = this.convert(amount, sourceUnit);
        if (amountOfThisUnit.equals(BigInteger.ZERO)) {
            return false;
        }
        return amountOfThisUnit.compareTo(UNIT_UPCONVERT_THRESHOLD_BIG) >= 0;
    }

    public static StorageUnit getAppropriateBinaryUnit(BigInteger amount, StorageUnit sourceUnit) {
        return StorageUnit.getAppropriateUnit(amount, sourceUnit, BINARY_QUANTIFIERS);
    }

    public static StorageUnit getAppropriateDecimalUnit(BigInteger amount, StorageUnit sourceUnit) {
        return StorageUnit.getAppropriateUnit(amount, sourceUnit, DECIMAL_QUANTIFIERS);
    }

    public static StorageUnit getAppropriateUnit(BigInteger amount, StorageUnit sourceUnit, StorageUnit[] options) {
        for (int i = options.length - 1; i >= 0; --i) {
            if (!options[i].isSensibleUnitFor(amount, sourceUnit)) continue;
            return options[i];
        }
        return sourceUnit;
    }

    public static StorageUnit smallest(StorageUnit unit, StorageUnit unit2) {
        if (unit == unit2 || unit.equals((Object)unit2)) {
            return unit;
        }
        if (unit.numBits.compareTo(unit2.numBits) < 0) {
            return unit;
        }
        return unit2;
    }

    public static StorageUnit largest(StorageUnit unit, StorageUnit unit2) {
        if (unit == unit2 || unit.equals((Object)unit2)) {
            return unit;
        }
        if (unit.numBits.compareTo(unit2.numBits) > 0) {
            return unit;
        }
        return unit2;
    }

    public static StorageUnit parseISO(String toParse) {
        if (toParse == null || toParse.isEmpty()) {
            throw new IllegalArgumentException("Must provide a string to parse!");
        }
        for (StorageUnit unit : StorageUnit.values()) {
            if (!unit.isoUnit.equals(toParse)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Cannot parse as ISO short-form storage unit: " + toParse + " (is the case incorrect?)");
    }

    public static StorageUnit parse(String original) {
        String toParse = original.length() == 2 && Character.isUpperCase(original.charAt(1)) ? new String(new char[]{original.charAt(0), 'i', original.charAt(1)}) : original;
        for (StorageUnit unit : StorageUnit.values()) {
            if (!unit.isoUnit.equals(toParse)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Cannot parse as short-form storage unit: " + original + " (nor could be parsed as " + toParse + "). Case incorrect?");
    }

    static {
        NETWORK_DECIMAL = new StorageUnit[]{BITS, KILOBITS, MEGABITS, GIGABITS, TERABITS, PETABITS, EXABITS, ZETTABITS, YOTTABITS};
        STORAGE_DECIMAL = new StorageUnit[]{BITS, BYTES, DECIMAL_KILOBYTES, DECIMAL_MEGABYTES, DECIMAL_GIGABYTES, DECIMAL_TERABYTES, DECIMAL_PETABYTES, DECIMAL_EXABYTES, DECIMAL_EXABYTES, DECIMAL_ZETTABYTES, DECIMAL_YOTTABYTES};
        COMPSCI_BINARY = new StorageUnit[]{BITS, BYTES, KILOBYTES, MEGABYTES, GIGABYTES, TERABYTES, PETABYTES, EXABYTES, ZETTABYTES, YOTTABYTES};
        DECIMAL_QUANTIFIERS = STORAGE_DECIMAL;
        BINARY_QUANTIFIERS = COMPSCI_BINARY;
        MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        UNIT_UPCONVERT_THRESHOLD_BIG = BigInteger.valueOf(8L);
    }
}

