/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HybridIterator<T>
implements Iterator<T>,
Enumeration<T>,
Iterable<T> {
    private final T[] items;
    private int i = 0;
    private final int itemsSize;
    private final Iterator<T> itemsIterator;
    private final Enumeration<T> itemsEnumerator;

    public HybridIterator(T[] items) {
        this(items, 0, items.length);
    }

    public HybridIterator(T[] items, int offset, int length) {
        assert (offset + length <= items.length && length >= 0);
        this.items = items;
        this.i = offset;
        this.itemsSize = length;
        this.itemsIterator = null;
        this.itemsEnumerator = null;
    }

    public HybridIterator(Iterator<T> items) {
        this.items = null;
        this.itemsSize = 0;
        this.itemsIterator = items;
        this.itemsEnumerator = null;
    }

    public HybridIterator(Iterable<T> items) {
        this.items = null;
        this.itemsSize = 0;
        this.itemsIterator = items.iterator();
        this.itemsEnumerator = null;
    }

    public HybridIterator(Enumeration<T> items) {
        this.items = null;
        this.itemsSize = 0;
        this.itemsIterator = null;
        this.itemsEnumerator = items;
    }

    @Override
    public boolean hasNext() {
        if (this.items != null) {
            return this.i != this.itemsSize;
        }
        if (this.itemsIterator != null) {
            return this.itemsIterator.hasNext();
        }
        return this.itemsEnumerator.hasMoreElements();
    }

    @Override
    public T next() {
        if (this.items != null) {
            if (this.itemsSize == this.i) {
                throw new NoSuchElementException();
            }
            return this.items[this.i++];
        }
        if (this.itemsIterator != null) {
            return this.itemsIterator.next();
        }
        return this.itemsEnumerator.nextElement();
    }

    @Override
    public void remove() {
        if (this.itemsIterator == null) {
            throw new UnsupportedOperationException();
        }
        this.itemsIterator.remove();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public T nextElement() {
        return this.next();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

