/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading;

import com.peterphi.std.threading.Deadline;
import com.peterphi.std.threading.ParamInvokeable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SettableFuture<T>
implements Future<T> {
    private static final transient Logger log = Logger.getLogger(SettableFuture.class);
    private T value = null;
    private Throwable exception = null;
    private AtomicInteger state = new AtomicInteger(0);
    private static final int STATE_UNSET = 0;
    private static final int STATE_SETTING = 1;
    private static final int STATE_SET = 3;
    private static final int STATE_CANCELLED = 5;
    private final ParamInvokeable<SettableFuture<T>> onSet;
    private final ParamInvokeable<SettableFuture<T>> onCancel;

    public SettableFuture() {
        this(null, null);
    }

    public SettableFuture(ParamInvokeable<SettableFuture<T>> onSet, ParamInvokeable<SettableFuture<T>> onCancel) {
        this.onSet = onSet;
        this.onCancel = onCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        if (this.state.compareAndSet(0, 1)) {
            this.value = value;
            this.state.set(3);
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                this.notifyAll();
            }
        } else {
            throw new IllegalStateException("Cannot set the value twice!");
        }
        this.on_set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(Throwable exception) {
        if (this.state.compareAndSet(0, 1)) {
            this.value = null;
            this.exception = exception;
            this.state.set(3);
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                this.notifyAll();
            }
        } else {
            throw new IllegalStateException("Cannot set the value twice!");
        }
        this.on_set();
    }

    protected void on_set() {
        if (this.onSet != null) {
            this.onSet.call(this);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (!this.state.compareAndSet(0, 5)) {
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                this.notifyAll();
            }
            this.on_cancel();
            return true;
        }
        return false;
    }

    protected void on_cancel() {
        if (this.onCancel != null) {
            this.onCancel.call(this);
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (true) {
            T tmpvalue = null;
            try {
                tmpvalue = this.get(Deadline.MAX_VALUE);
                if (log.isInfoEnabled()) {
                    log.info((Object)("[TransferFuture] {get} returning value " + tmpvalue));
                }
                return tmpvalue;
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public final T poll() throws ExecutionException {
        int state = this.state.get();
        switch (state) {
            case 3: {
                if (this.exception != null) {
                    throw new ExecutionException("Operation threw Exception: " + this.exception.getMessage(), this.exception);
                }
                return this.value;
            }
            case 5: {
                throw new ExecutionException("Operation cancelled", null);
            }
        }
        return null;
    }

    @Override
    public final T get(long quantity, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Deadline deadline = new Deadline(quantity, unit);
        return this.get(deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(Deadline deadline) throws InterruptedException, ExecutionException, TimeoutException {
        while (deadline.isValid()) {
            switch (this.state.get()) {
                case 3: 
                case 5: {
                    return this.poll();
                }
            }
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                long sleepTime = Math.min(10000L, deadline.getTimeLeft());
                this.wait(sleepTime);
            }
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == 5;
    }

    @Override
    public boolean isDone() {
        return this.state.get() == 3;
    }
}

