/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.system.exec;

import com.peterphi.std.system.exec.Execed;
import com.peterphi.std.threading.Deadline;
import com.peterphi.std.threading.Timeout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

class SudoFeature {
    private static final transient Logger log = Logger.getLogger(SudoFeature.class);
    private static boolean dashDashTested = false;
    private static boolean dashDashSupported;
    private static boolean dashNTested;
    private static boolean dashNSupported;
    private static boolean sudoTested;
    private static boolean sudoSupported;

    SudoFeature() {
    }

    public static boolean hasSaneSudo() {
        return SudoFeature.hasSudo() && SudoFeature.hasNonInteractive() && SudoFeature.hasArgumentsEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasSudo() {
        if (!sudoTested) {
            String[] cmdArr = new String[]{"which", "sudo"};
            ArrayList<String> cmd = new ArrayList<String>(cmdArr.length);
            Collections.addAll(cmd, cmdArr);
            ProcessBuilder whichsudo = new ProcessBuilder(cmd);
            try {
                Process p = whichsudo.start();
                try {
                    Execed e = new Execed(cmd, p, false);
                    int returnCode = e.waitForExit(new Deadline(3L, TimeUnit.SECONDS));
                    sudoSupported = returnCode == 0;
                    sudoTested = true;
                }
                finally {
                    p.destroy();
                }
            }
            catch (Throwable t) {
                sudoSupported = false;
                sudoTested = true;
            }
        }
        return sudoSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasNonInteractive() {
        block11: {
            if (!SudoFeature.hasSudo()) {
                return false;
            }
            if (!dashNTested) {
                Process p = null;
                try {
                    String[] cmdArr = new String[]{"sudo", "-n", "whoami"};
                    ArrayList<String> cmd = new ArrayList<String>(cmdArr.length);
                    Collections.addAll(cmd, cmdArr);
                    ProcessBuilder whoami = new ProcessBuilder(cmd);
                    p = whoami.start();
                    Execed e = new Execed(cmd, p, false);
                    int returnCode = e.waitForExit(Timeout.TEN_SECONDS.start());
                    if (returnCode == 0) {
                        dashNTested = true;
                        dashNSupported = true;
                        break block11;
                    }
                    if (returnCode == 1) {
                        dashNSupported = false;
                        dashNTested = true;
                        break block11;
                    }
                    if (returnCode == Integer.MIN_VALUE) {
                        dashNSupported = false;
                        dashNTested = true;
                        break block11;
                    }
                    throw new Error("sudo -n whoami returned " + returnCode + " (expected 0, 1 or Integer.MIN_VALUE)");
                }
                catch (Throwable t) {
                    log.warn((Object)("{runasSupportsNoninteractiveMode} Cannot determine support. Exception: " + t.getMessage()), t);
                    dashNSupported = false;
                    dashNTested = true;
                }
                finally {
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
        }
        return dashNSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasArgumentsEnd() {
        if (!SudoFeature.hasSudo() || !SudoFeature.hasNonInteractive()) {
            return false;
        }
        if (!dashDashTested) {
            try {
                Execed e;
                ProcessBuilder whoami;
                ArrayList<String> cmd;
                String[] cmdArr;
                Process p = null;
                try {
                    cmdArr = new String[]{"sudo", "-n", "whoami"};
                    cmd = new ArrayList<String>(cmdArr.length);
                    Collections.addAll(cmd, cmdArr);
                    whoami = new ProcessBuilder(cmd);
                    p = whoami.start();
                    e = new Execed(cmd, p, true);
                    e.waitForExit(0);
                }
                finally {
                    if (p != null) {
                        p.destroy();
                    }
                }
                p = null;
                try {
                    cmdArr = new String[]{"sudo", "-n", "--", "whoami"};
                    cmd = new ArrayList(cmdArr.length);
                    Collections.addAll(cmd, cmdArr);
                    whoami = new ProcessBuilder(cmd);
                    p = whoami.start();
                    e = new Execed(cmd, p, true);
                    int returnCode = e.waitForExit();
                    dashDashSupported = returnCode == 0;
                    dashDashTested = true;
                }
                finally {
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (Throwable e) {
                dashDashSupported = false;
                dashDashTested = true;
                log.warn((Object)("{runasSupportsArgumentEndToken} Cannot determine support. Error: " + e.getMessage()), e);
            }
        }
        return dashDashSupported;
    }

    static {
        dashNTested = false;
        sudoTested = false;
    }
}

