/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FilenameExtensionFilter
implements FileFilter {
    private final Set<String> extensions;
    private final boolean caseSensitive;

    @Deprecated
    public FilenameExtensionFilter(String extension, boolean caseSensitive) {
        this(caseSensitive, extension);
    }

    @Deprecated
    public FilenameExtensionFilter(Iterable<String> extensions, boolean caseSensitive) {
        this(caseSensitive, extensions);
    }

    public FilenameExtensionFilter(boolean caseSensitive, String ... extensions) {
        this(caseSensitive, Arrays.asList(extensions));
    }

    public FilenameExtensionFilter(String ... extensions) {
        this(Arrays.asList(extensions));
    }

    public FilenameExtensionFilter(Iterable<String> extensions) {
        this(false, extensions);
    }

    public FilenameExtensionFilter(boolean caseSensitive, Iterable<String> extensions) {
        this.caseSensitive = caseSensitive;
        this.extensions = new HashSet<String>();
        for (String extension : extensions) {
            String ext = "." + (caseSensitive ? extension : extension.toLowerCase());
            this.extensions.add(ext);
        }
    }

    public boolean accept(File dir, String name) {
        return this.accept(name);
    }

    @Override
    public boolean accept(File pathname) {
        return this.accept(pathname.getName());
    }

    public boolean accept(String name) {
        if (!this.caseSensitive) {
            name = name.toLowerCase();
        }
        for (String extension : this.extensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

