/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io;

import com.peterphi.std.io.ICopyProgressMonitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class StreamUtil {
    private static final Logger log = Logger.getLogger(StreamUtil.class);
    public static final int STREAM_SLEEP_TIME = 5;
    public static final int CHUNKSIZE = 8192;
    public static final int MONITOR_UPDATE_INTERVAL = 10;
    public static final DummyMonitor DUMMY_MONITOR = new DummyMonitor();

    private StreamUtil() {
    }

    public static InputStream routeStreamThroughProcess(Process p, InputStream origin, boolean closeInput) {
        InputStream processSTDOUT = p.getInputStream();
        OutputStream processSTDIN = p.getOutputStream();
        StreamUtil.doBackgroundCopy(origin, processSTDIN, DUMMY_MONITOR, true, closeInput);
        return processSTDOUT;
    }

    public static long eatInputStream(InputStream is) {
        try {
            long eaten = 0L;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int avail = Math.min(is.available(), 8192);
            byte[] eatingArray = new byte[8192];
            while (avail > 0) {
                is.read(eatingArray, 0, avail);
                eaten += (long)avail;
                if (avail < 8192) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                avail = Math.min(is.available(), 8192);
            }
            return eaten;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public static void doBackgroundCopy(InputStream isI, OutputStream osI) {
        StreamUtil.doBackgroundCopy(isI, osI, DUMMY_MONITOR);
    }

    public static void doBackgroundCopy(InputStream is, OutputStream os, ICopyProgressMonitor monitor) {
        StreamUtil.doBackgroundCopy(is, os, monitor, true, false);
    }

    public static void doBackgroundCopy(final InputStream is, final OutputStream os, final ICopyProgressMonitor monitor, final boolean closeOutput, final boolean closeInput) {
        if (null == monitor) {
            throw new IllegalArgumentException("Must provide a monitor (try StreamUtil.DUMMY_MONITOR)");
        }
        Thread eatThread = new Thread(){

            @Override
            public void run() {
                try {
                    StreamUtil.streamCopy(is, os, monitor);
                }
                finally {
                    if (closeOutput || closeInput) {
                        try {
                            if (closeOutput) {
                                os.close();
                            }
                            if (closeInput) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        eatThread.setName("backgroundCopy " + is + " to " + os);
        eatThread.setDaemon(true);
        eatThread.start();
    }

    public static void streamCopy(InputStream in, OutputStream out) {
        StreamUtil.streamCopy(in, out, DUMMY_MONITOR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void streamCopy(InputStream in, OutputStream out, ICopyProgressMonitor monitor) {
        if (null == monitor) {
            StreamUtil.streamCopy(in, out, DUMMY_MONITOR);
            return;
        }
        try {
            monitor.start();
            monitor.blocksize(8192);
            byte[] eatingArray = new byte[8192];
            int loops = 0;
            long totalSize = 0L;
            while (true) {
                int numbytes;
                if ((numbytes = in.read(eatingArray, 0, 8192)) == -1) {
                    return;
                }
                totalSize += (long)numbytes;
                out.write(eatingArray, 0, numbytes);
                if (numbytes < 8192) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (0 != ++loops % 10) continue;
                monitor.progress(totalSize);
                continue;
                break;
            }
        }
        catch (IOException e) {
            log.error((Object)("[StreamUtil] {streamCopy} IO Exception: " + e.getMessage()), (Throwable)e);
            monitor.failure();
            throw new IOError(e);
        }
        catch (Error e) {
            monitor.failure();
            throw e;
        }
        finally {
            monitor.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is, int size) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(size);){
            int left = size;
            byte[] buffer = new byte[1024];
            while (left != 0) {
                int read = is.read(buffer, 0, Math.min(buffer.length, left));
                if (read == -1) {
                    throw new IOException("Error reading from InputStream");
                }
                if (read == 0) continue;
                os.write(buffer, 0, read);
                left -= read;
            }
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(Reader reader, Writer writer) throws IOException {
        try (Reader in = reader.getClass() == BufferedReader.class ? reader : new BufferedReader(reader);
             Writer out = writer.getClass() == BufferedWriter.class ? writer : new BufferedWriter(writer);){
            char[] buffer = new char[4096];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
    }

    public static void streamCopy(InputStream input, Writer output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Must provide something to read from");
        }
        if (output == null) {
            throw new IllegalArgumentException("Must provide something to write to");
        }
        StreamUtil.streamCopy(new InputStreamReader(input), output);
    }

    private static final class DummyMonitor
    implements ICopyProgressMonitor {
        private DummyMonitor() {
        }

        @Override
        public void blocksize(int size) {
        }

        @Override
        public void complete() {
        }

        @Override
        public void failure() {
        }

        @Override
        public void progress(long bytes) {
        }

        @Override
        public void size(long bytes) {
        }

        @Override
        public void start() {
        }
    }
}

